/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.blocks;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.shotrush.atom.Atom;
import org.shotrush.atom.content.blocks.cog.CogManager;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;
import org.shotrush.atom.core.blocks.BlockType;
import org.shotrush.atom.core.blocks.CustomBlock;
import org.shotrush.atom.core.blocks.CustomBlockDataManager;
import org.shotrush.atom.core.blocks.CustomBlockRegistry;
import org.shotrush.atom.core.blocks.InteractiveSurface;
import org.shotrush.atom.core.blocks.annotation.AutoRegister;
import org.shotrush.atom.core.data.PersistentData;
import org.shotrush.atom.core.util.ActionBarManager;

public class CustomBlockManager
implements Listener {
    private final Atom plugin;
    public final CustomBlockRegistry registry;
    private final NamespacedKey wrenchKey;
    public final List<CustomBlock> blocks;
    private final CustomBlockDataManager dataManager;
    private ScheduledTask globalUpdateTask;
    private float globalAngle = 0.0f;

    public CustomBlockManager(Atom plugin) {
        this.plugin = plugin;
        this.registry = new CustomBlockRegistry(plugin);
        this.wrenchKey = new NamespacedKey((Plugin)plugin, "wrench");
        this.blocks = new ArrayList<CustomBlock>();
        this.dataManager = new CustomBlockDataManager(plugin, this.registry);
        this.registerBlockTypes();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        SchedulerAPI.runGlobalTaskLater(() -> {
            this.loadBlocks();
            this.startGlobalUpdate();
        }, 1L);
    }

    private void registerBlockTypes() {
        this.plugin.getLogger().info("Auto-registering block types...");
        try {
            Reflections reflections = new Reflections("org.shotrush.atom", new Scanner[0]);
            Set<Class<?>> annotatedClasses = reflections.getTypesAnnotatedWith(AutoRegister.class);
            List sortedClasses = annotatedClasses.stream().sorted(Comparator.comparingInt(cls -> cls.getAnnotation(AutoRegister.class).priority())).collect(Collectors.toList());
            for (Class clazz : sortedClasses) {
                if (!BlockType.class.isAssignableFrom(clazz)) continue;
                try {
                    if (CustomBlock.class.isAssignableFrom(clazz)) {
                        this.registry.register(clazz, this.plugin);
                        this.plugin.getLogger().info("  \u2713 Registered: " + clazz.getSimpleName());
                        continue;
                    }
                    Constructor constructor = clazz.getConstructor(Atom.class);
                    BlockType blockType = (BlockType)constructor.newInstance(this.plugin);
                    this.registry.register(blockType.getIdentifier(), blockType);
                    this.plugin.getLogger().info("  \u2713 Registered: " + blockType.getIdentifier());
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to register block type: " + clazz.getName());
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to auto-register block types!");
            e.printStackTrace();
        }
    }

    private void startGlobalUpdate() {
        this.globalUpdateTask = SchedulerAPI.runGlobalTaskTimer(() -> {
            this.globalAngle += 0.1f;
            if ((double)this.globalAngle > Math.PI * 2) {
                this.globalAngle = 0.0f;
            }
            for (CustomBlock block : new ArrayList<CustomBlock>(this.blocks)) {
                BlockType type = this.registry.getBlockType(block.getBlockType());
                if (type == null || !type.requiresUpdate()) continue;
                block.update(this.globalAngle);
            }
        }, 1L, 1L);
    }

    public void stopGlobalUpdate() {
        if (this.globalUpdateTask != null) {
            this.globalUpdateTask.cancel();
        }
    }

    private void loadBlocks() {
        List<CustomBlock> loadedBlocks = this.dataManager.loadBlocks();
        this.blocks.addAll(loadedBlocks);
        this.plugin.getLogger().info("Loaded " + loadedBlocks.size() + " block(s) from data");
        SchedulerAPI.runGlobalTaskLater(() -> {
            int spawnedCount = 0;
            for (CustomBlock block : this.blocks) {
                if (block.getSpawnLocation().getWorld() == null) continue;
                block.setDisplayUUID(null);
                block.setInteractionUUID(null);
                if (block instanceof InteractiveSurface) {
                    InteractiveSurface surface = (InteractiveSurface)block;
                    for (InteractiveSurface.PlacedItem item : surface.getPlacedItems()) {
                        item.setDisplayUUID(null);
                    }
                    this.plugin.getLogger().info("Cleared stale UUIDs for " + block.getIdentifier());
                } else {
                    this.plugin.getLogger().info("Cleared stale UUIDs for " + block.getIdentifier());
                }
                block.spawn(this.plugin);
                ++spawnedCount;
            }
            this.plugin.getLogger().info("Spawned " + spawnedCount + " block(s) after world load");
            CogManager cogManager = new CogManager(this.plugin);
            cogManager.recalculatePower(this.blocks);
        }, 20L);
    }

    public void saveBlocks() {
        this.blocks.removeIf(block -> !block.isValid());
        this.dataManager.saveBlocks(this.blocks);
        this.plugin.getLogger().info("Saved " + this.blocks.size() + " block(s)");
    }

    public void cleanupAllDisplays() {
        this.plugin.getLogger().info("Skipping entity cleanup on shutdown (Folia-safe)");
    }

    public void removeAllBlocks() {
        for (CustomBlock block : this.blocks) {
            block.remove();
        }
        this.blocks.clear();
        this.dataManager.saveBlocks(this.blocks);
        this.plugin.getLogger().info("Removed all blocks");
    }

    public ItemStack createWrench() {
        ItemStack wrench = new ItemStack(Material.WOODEN_HOE);
        ItemMeta meta = wrench.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7e\ud83d\udd27 Mechanical Wrench");
            meta.setLore(Arrays.asList("\u00a77A tool for working with blocks", "\u00a78\u2022 Right-click: Interact", "\u00a78\u2022 Shift + Right-click: Remove", "\u00a78[Engineering Tool]"));
            PersistentData.flag((PersistentDataHolder)meta, this.wrenchKey.getKey());
            meta.setUnbreakable(true);
            wrench.setItemMeta(meta);
        }
        return wrench;
    }

    public void giveBlockItem(Player player, String blockTypeId) {
        ItemStack item = this.createBlockItem(blockTypeId);
        if (item == null) {
            ActionBarManager.send(player, "\u00a7cUnknown block type: " + blockTypeId);
            return;
        }
        player.getInventory().addItem(new ItemStack[]{item});
        ActionBarManager.send(player, "\u00a7aYou received a " + item.getItemMeta().getDisplayName() + "!");
    }

    public ItemStack createBlockItem(String blockTypeId) {
        BlockType blockType = this.registry.getBlockType(blockTypeId);
        if (blockType == null) {
            return null;
        }
        ItemStack item = new ItemStack(blockType.getItemMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(blockType.getDisplayName());
            meta.setLore(Arrays.asList(blockType.getLore()));
            CustomModelDataComponent component = meta.getCustomModelDataComponent();
            component.setStrings(List.of(blockTypeId));
            meta.setCustomModelDataComponent(component);
            NamespacedKey key = this.registry.getKey(blockTypeId);
            PersistentData.flag((PersistentDataHolder)meta, key.getKey());
            item.setItemMeta(meta);
        }
        return item;
    }

    public void giveWrench(Player player) {
        ItemStack wrench = this.plugin.getItemRegistry().createItem("wrench");
        if (wrench != null) {
            player.getInventory().addItem(new ItemStack[]{wrench});
            ActionBarManager.send(player, "\u00a7aYou received a Mechanical Wrench!");
        }
    }

    public CustomBlock getBlockAt(Location location) {
        for (CustomBlock block : this.blocks) {
            if (!block.getBlockLocation().equals((Object)location)) continue;
            return block;
        }
        return null;
    }

    private void updateBlockEntityUUIDs(CustomBlock block) {
        if (block.getSpawnLocation().getWorld() == null) {
            return;
        }
        for (Entity entity : block.getSpawnLocation().getWorld().getNearbyEntities(block.getSpawnLocation(), 0.5, 0.5, 0.5)) {
            double distance = entity.getLocation().distance(block.getSpawnLocation());
            if (!(distance < 0.1)) continue;
            if (entity instanceof ItemDisplay) {
                block.setDisplayUUID(entity.getUniqueId());
                continue;
            }
            if (!(entity instanceof Interaction)) continue;
            block.setInteractionUUID(entity.getUniqueId());
        }
    }

    public void removeBlock(CustomBlock block) {
        block.remove();
        this.blocks.remove(block);
        block.onRemoved();
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemStack item = event.getItemInHand();
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        for (Map.Entry<String, BlockType> entry : this.registry.getAllBlockTypes().entrySet()) {
            NamespacedKey key;
            BlockType blockType = entry.getValue();
            if (item.getType() != blockType.getItemMaterial() || !PersistentData.isFlagged((PersistentDataHolder)meta, (key = this.registry.getKey(entry.getKey())).getKey())) continue;
            event.setCancelled(true);
            Location blockLocation = event.getBlock().getLocation();
            Location spawnLocation = blockLocation.clone().add(0.5, 0.0, 0.5);
            for (CustomBlock existingBlock : this.blocks) {
                if (!existingBlock.getBlockLocation().equals((Object)blockLocation)) continue;
                event.getPlayer().sendMessage("\u00a7cA block is already placed here!");
                return;
            }
            CustomBlock customBlock = blockType.createBlock(spawnLocation, blockLocation, event.getBlockAgainst().getFace(event.getBlock()));
            customBlock.spawn(this.plugin);
            this.blocks.add(customBlock);
            customBlock.onPlaced();
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
            } else {
                event.getPlayer().getInventory().setItem(event.getHand(), new ItemStack(Material.AIR));
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Interaction)) {
            return;
        }
        Interaction interaction = (Interaction)entity;
        for (int i = 0; i < this.blocks.size(); ++i) {
            CustomBlock block = this.blocks.get(i);
            if (block.getInteractionUUID() == null || !block.getInteractionUUID().equals(entity.getUniqueId())) continue;
            SchedulerAPI.runTask(interaction.getLocation(), () -> {
                Entity ent = Bukkit.getEntity((UUID)interaction.getUniqueId());
                if (ent instanceof Interaction) {
                    Interaction inter = (Interaction)ent;
                    inter.setResponsive(false);
                    inter.setResponsive(true);
                }
            });
            this.handleBlockInteraction(block, i, event.getPlayer(), (Cancellable)event);
            return;
        }
        Location interactionLoc = interaction.getLocation();
        for (int i = 0; i < this.blocks.size(); ++i) {
            CustomBlock block = this.blocks.get(i);
            Location blockLoc = block.getSpawnLocation();
            if (!blockLoc.getWorld().equals((Object)interactionLoc.getWorld()) || !(blockLoc.distance(interactionLoc) < 0.5)) continue;
            block.setInteractionUUID(entity.getUniqueId());
            for (Entity nearbyEntity : blockLoc.getWorld().getNearbyEntities(blockLoc, 1.0, 1.0, 1.0)) {
                if (!(nearbyEntity instanceof ItemDisplay) || !(nearbyEntity.getLocation().distance(blockLoc) < 0.5)) continue;
                block.setDisplayUUID(nearbyEntity.getUniqueId());
                this.plugin.getLogger().info("Updated display and interaction UUIDs for block at " + String.valueOf(blockLoc));
                break;
            }
            if (block instanceof InteractiveSurface) {
                InteractiveSurface surface = (InteractiveSurface)block;
                surface.updateItemDisplayUUIDs();
                this.plugin.getLogger().info("Updated item display UUIDs for InteractiveSurface");
            }
            SchedulerAPI.runTask(interaction.getLocation(), () -> {
                Entity ent = Bukkit.getEntity((UUID)interaction.getUniqueId());
                if (ent instanceof Interaction) {
                    Interaction inter = (Interaction)ent;
                    inter.setResponsive(false);
                    inter.setResponsive(true);
                }
            });
            this.handleBlockInteraction(block, i, event.getPlayer(), (Cancellable)event);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        if (!(event.getEntity() instanceof Interaction)) {
            return;
        }
        Player player = (Player)event.getDamager();
        Interaction interaction = (Interaction)event.getEntity();
        for (int i = 0; i < this.blocks.size(); ++i) {
            CustomBlock block = this.blocks.get(i);
            if (block.getInteractionUUID() == null || !block.getInteractionUUID().equals(interaction.getUniqueId())) continue;
            event.setCancelled(true);
            if (block.getBlockLocation().getBlock().getType() != Material.BLACK_STAINED_GLASS) {
                ItemStack dropItem;
                BlockType blockType = this.registry.getBlockType(block.getBlockType());
                if (blockType != null && (dropItem = blockType.getDropItem()) != null) {
                    block.getSpawnLocation().getWorld().dropItemNaturally(block.getSpawnLocation(), dropItem);
                }
                block.remove();
                this.blocks.remove(i);
                block.onRemoved();
                ActionBarManager.send(player, "\u00a7cCustom block removed");
            }
            return;
        }
        Location interactionLoc = interaction.getLocation();
        for (int i = 0; i < this.blocks.size(); ++i) {
            CustomBlock block = this.blocks.get(i);
            Location blockLoc = block.getSpawnLocation();
            if (!blockLoc.getWorld().equals((Object)interactionLoc.getWorld()) || !(blockLoc.distance(interactionLoc) < 0.5)) continue;
            block.setInteractionUUID(interaction.getUniqueId());
            for (Entity nearbyEntity : blockLoc.getWorld().getNearbyEntities(blockLoc, 1.0, 1.0, 1.0)) {
                if (!(nearbyEntity instanceof ItemDisplay) || !(nearbyEntity.getLocation().distance(blockLoc) < 0.5)) continue;
                block.setDisplayUUID(nearbyEntity.getUniqueId());
                break;
            }
            if (block instanceof InteractiveSurface) {
                InteractiveSurface surface = (InteractiveSurface)block;
                surface.updateItemDisplayUUIDs();
            }
            event.setCancelled(true);
            if (block.getBlockLocation().getBlock().getType() != Material.BLACK_STAINED_GLASS) {
                ItemStack dropItem;
                BlockType blockType = this.registry.getBlockType(block.getBlockType());
                if (blockType != null && (dropItem = blockType.getDropItem()) != null) {
                    block.getSpawnLocation().getWorld().dropItemNaturally(block.getSpawnLocation(), dropItem);
                }
                block.remove();
                this.blocks.remove(i);
                block.onRemoved();
                ActionBarManager.send(player, "\u00a7cCustom block removed");
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Material blockType = event.getBlock().getType();
        if (blockType != Material.BLACK_STAINED_GLASS) {
            return;
        }
        Location blockLoc = event.getBlock().getLocation();
        for (int i = 0; i < this.blocks.size(); ++i) {
            ItemStack dropItem;
            CustomBlock block = this.blocks.get(i);
            if (!block.getBlockLocation().equals((Object)blockLoc)) continue;
            BlockType blockTypeData = this.registry.getBlockType(block.getBlockType());
            if (blockTypeData != null && (dropItem = blockTypeData.getDropItem()) != null) {
                blockLoc.getWorld().dropItemNaturally(blockLoc, dropItem);
            }
            block.remove();
            this.blocks.remove(i);
            block.onRemoved();
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteractBlock(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        Material blockType = event.getClickedBlock().getType();
        if (blockType != Material.BLACK_STAINED_GLASS) {
            return;
        }
        Location clickedLoc = event.getClickedBlock().getLocation();
        for (int i = 0; i < this.blocks.size(); ++i) {
            CustomBlock block = this.blocks.get(i);
            if (!block.getBlockLocation().equals((Object)clickedLoc)) continue;
            this.handleBlockInteraction(block, i, event.getPlayer(), (Cancellable)event);
            return;
        }
    }

    private void handleBlockInteraction(CustomBlock block, int index, Player player, Cancellable event) {
        boolean hasWrench;
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        boolean bl = hasWrench = this.plugin.getItemRegistry().getItem("wrench") != null && this.plugin.getItemRegistry().getItem("wrench").isCustomItem(itemInHand);
        if (block instanceof InteractiveSurface) {
            if (hasWrench) {
                event.setCancelled(true);
                if (player.isSneaking()) {
                    if (block.onWrenchInteract(player, true)) {
                        return;
                    }
                    block.remove();
                    this.blocks.remove(index);
                    block.onRemoved();
                    ActionBarManager.send(player, "\u00a7cBlock removed!");
                    return;
                }
                block.onWrenchInteract(player, false);
                return;
            }
            boolean handled = block.onInteract(player, player.isSneaking());
            if (!handled) {
                handled = block.onWrenchInteract(player, false);
            }
            if (handled) {
                event.setCancelled(true);
            }
            return;
        }
        if (hasWrench) {
            event.setCancelled(true);
            if (player.isSneaking()) {
                if (block.onWrenchInteract(player, true)) {
                    return;
                }
                block.remove();
                this.blocks.remove(index);
                block.onRemoved();
                ActionBarManager.send(player, "\u00a7cBlock removed!");
                return;
            }
            block.onWrenchInteract(player, false);
            return;
        }
        block.onInteract(player, player.isSneaking());
    }

    @Generated
    public CustomBlockRegistry getRegistry() {
        return this.registry;
    }

    @Generated
    public List<CustomBlock> getBlocks() {
        return this.blocks;
    }
}

