/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.blocks;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.Atom;
import org.shotrush.atom.core.blocks.BlockType;
import org.shotrush.atom.core.blocks.CustomBlock;

public class CustomBlockRegistry {
    private final Atom plugin;
    private final Map<String, BlockType> blockTypes;
    private final Map<NamespacedKey, String> keyToIdentifier;

    public CustomBlockRegistry(Atom plugin) {
        this.plugin = plugin;
        this.blockTypes = new HashMap<String, BlockType>();
        this.keyToIdentifier = new HashMap<NamespacedKey, String>();
    }

    public void register(Class<?> blockClass, Plugin plugin) throws Exception {
        CustomBlock prototypeBlock = null;
        Location dummyLoc = new Location(null, 0.0, 0.0, 0.0);
        try {
            prototypeBlock = (CustomBlock)blockClass.getConstructor(Location.class, BlockFace.class).newInstance(dummyLoc, BlockFace.UP);
        }
        catch (NoSuchMethodException e) {
            try {
                prototypeBlock = (CustomBlock)blockClass.getConstructor(Location.class, Location.class, BlockFace.class).newInstance(dummyLoc, dummyLoc, BlockFace.UP);
            }
            catch (NoSuchMethodException e2) {
                prototypeBlock = (CustomBlock)blockClass.getConstructor(Location.class, BlockFace.class, Boolean.TYPE).newInstance(dummyLoc, BlockFace.UP, false);
            }
        }
        String identifier = prototypeBlock.getIdentifier();
        this.blockTypes.put(identifier, prototypeBlock);
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, identifier + "_item");
        this.keyToIdentifier.put(key, identifier);
        this.plugin.getLogger().info("Registered block type: " + identifier + " (" + blockClass.getSimpleName() + ")");
    }

    public void register(String identifier, BlockType blockType) {
        this.blockTypes.put(identifier, blockType);
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, identifier + "_item");
        this.keyToIdentifier.put(key, identifier);
        this.plugin.getLogger().info("Registered block type: " + identifier);
    }

    public BlockType getBlockType(String identifier) {
        return this.blockTypes.get(identifier);
    }

    public String getIdentifier(NamespacedKey key) {
        return this.keyToIdentifier.get(key);
    }

    public NamespacedKey getKey(String identifier) {
        return new NamespacedKey((Plugin)this.plugin, identifier + "_item");
    }

    public Map<String, BlockType> getAllBlockTypes() {
        return new HashMap<String, BlockType>(this.blockTypes);
    }
}

