/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.shotrush.atom.Atom;
import org.shotrush.atom.core.api.annotation.RegisterSystem;
import org.shotrush.atom.core.blocks.CustomBlock;
import org.shotrush.atom.core.blocks.CustomBlockManager;
import org.shotrush.atom.core.blocks.annotation.CustomBlockTypeDrops;

@RegisterSystem(id="custom_block_type_drop_handler", priority=9, toggleable=false, description="Handles bonus drops from @CustomBlockTypeDrops annotation on custom blocks")
public class CustomBlockTypeDropHandler
implements Listener {
    private static final Map<Class<? extends CustomBlock>, DropConfigWithAge> customDrops = new HashMap<Class<? extends CustomBlock>, DropConfigWithAge>();
    private static final Random random = new Random();
    private final Atom plugin;

    public CustomBlockTypeDropHandler(Plugin plugin) {
        this.plugin = (Atom)plugin;
        this.scanForCustomDrops();
    }

    private void scanForCustomDrops() {
        try {
            Reflections reflections = new Reflections("org.shotrush.atom", new Scanner[0]);
            Set<Class<?>> annotatedClasses = reflections.getTypesAnnotatedWith(CustomBlockTypeDrops.class);
            for (Class<?> clazz : annotatedClasses) {
                CustomBlockTypeDrops annotation;
                if (!CustomBlock.class.isAssignableFrom(clazz) || (annotation = clazz.getAnnotation(CustomBlockTypeDrops.class)) == null) continue;
                this.registerDrops(clazz, annotation);
            }
            this.plugin.getLogger().info("Loaded custom block type drops for " + customDrops.size() + " block types");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to scan for custom block type drops: " + e.getMessage());
        }
    }

    private void registerDrops(Class<? extends CustomBlock> blockClass, CustomBlockTypeDrops annotation) {
        HashSet<String> allowedAges = new HashSet<String>(Arrays.asList(annotation.ages()));
        ArrayList<DropConfig> drops = new ArrayList<DropConfig>();
        for (CustomBlockTypeDrops.Drop drop2 : annotation.drops()) {
            drops.add(new DropConfig(drop2.material(), drop2.customItemId(), drop2.chance(), drop2.min(), drop2.max()));
        }
        customDrops.put(blockClass, new DropConfigWithAge(drops, allowedAges));
        String ageInfo = allowedAges.isEmpty() ? "all ages" : "ages: " + String.join((CharSequence)", ", allowedAges);
        this.plugin.getLogger().info("Registered " + annotation.drops().length + " bonus drops for " + blockClass.getSimpleName() + " (" + ageInfo + ")");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCustomBlockBreak(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Interaction)) {
            return;
        }
        Interaction interaction = (Interaction)entity;
        CustomBlockManager manager = this.plugin.getBlockManager();
        if (manager == null) {
            return;
        }
        for (CustomBlock block : manager.getBlocks()) {
            if (block.getInteractionUUID() == null || !block.getInteractionUUID().equals(interaction.getUniqueId())) continue;
            DropConfigWithAge dropConfig = customDrops.get(block.getClass());
            if (dropConfig == null) {
                return;
            }
            String currentAge = this.plugin.getAgeManager().getCurrentAge().getId();
            if (!dropConfig.allowedAges.isEmpty() && !dropConfig.allowedAges.contains(currentAge)) {
                return;
            }
            for (DropConfig drop2 : dropConfig.drops) {
                ItemStack itemToDrop;
                if (!(random.nextDouble() <= drop2.chance)) continue;
                int amount = drop2.min;
                if (drop2.max > drop2.min) {
                    amount = drop2.min + random.nextInt(drop2.max - drop2.min + 1);
                }
                if (!drop2.customItemId.isEmpty()) {
                    itemToDrop = this.plugin.getItemRegistry().createItem(drop2.customItemId);
                    if (itemToDrop == null) {
                        this.plugin.getLogger().warning("Custom item not found: " + drop2.customItemId);
                        continue;
                    }
                } else {
                    itemToDrop = new ItemStack(drop2.material);
                }
                itemToDrop.setAmount(amount);
                block.getSpawnLocation().getWorld().dropItemNaturally(block.getSpawnLocation(), itemToDrop);
            }
            return;
        }
    }

    private static class DropConfig {
        final Material material;
        final String customItemId;
        final double chance;
        final int min;
        final int max;

        DropConfig(Material material, String customItemId, double chance, int min2, int max) {
            this.material = material;
            this.customItemId = customItemId;
            this.chance = chance;
            this.min = min2;
            this.max = max;
        }
    }

    private static class DropConfigWithAge {
        final List<DropConfig> drops;
        final Set<String> allowedAges;

        DropConfigWithAge(List<DropConfig> drops, Set<String> allowedAges) {
            this.drops = drops;
            this.allowedAges = allowedAges;
        }
    }
}

