/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.momirealms.craftengine.bukkit.api.CraftEngineItems;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.WaterMob;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.shotrush.atom.Atom;
import org.shotrush.atom.content.AnimalType;
import org.shotrush.atom.core.api.annotation.RegisterSystem;
import org.shotrush.atom.core.blocks.annotation.CustomEntityDrops;

@RegisterSystem(id="custom_entity_drop_handler", priority=8, toggleable=false, description="Handles custom entity drops from @CustomEntityDrops annotation")
public class CustomEntityDropHandler
implements Listener {
    private static final Map<EntityType, List<DropConfigWithAge>> customDrops = new HashMap<EntityType, List<DropConfigWithAge>>();
    private static final Random random = new Random();

    public CustomEntityDropHandler(Plugin plugin) {
        this.scanForCustomDrops();
    }

    private void scanForCustomDrops() {
        try {
            Reflections reflections = new Reflections("org.shotrush.atom", new Scanner[0]);
            Set<Class<?>> annotatedClasses = reflections.getTypesAnnotatedWith(CustomEntityDrops.class);
            for (Class<?> clazz : annotatedClasses) {
                CustomEntityDrops annotation = clazz.getAnnotation(CustomEntityDrops.class);
                if (annotation == null) continue;
                this.registerDrops(annotation);
            }
            Atom.getInstance().getLogger().info("Loaded custom drops for " + customDrops.size() + " entity types");
        }
        catch (Exception e) {
            Atom.getInstance().getLogger().warning("Failed to scan for custom entity drops: " + e.getMessage());
        }
    }

    private void registerDrops(CustomEntityDrops annotation) {
        HashSet<String> allowedAges = new HashSet<String>(Arrays.asList(annotation.ages()));
        HashSet<EntityType> targetEntities = new HashSet<EntityType>();
        targetEntities.addAll(Arrays.asList(annotation.entities()));
        for (CustomEntityDrops.EntityCategory entityCategory : annotation.categories()) {
            targetEntities.addAll(this.getEntitiesFromCategory(entityCategory));
        }
        for (EntityType entityType : targetEntities) {
            List drops = customDrops.computeIfAbsent(entityType, k -> new ArrayList());
            for (CustomEntityDrops.Drop drop2 : annotation.drops()) {
                drops.add(new DropConfigWithAge(drop2.customItemId(), drop2.minAmount(), drop2.maxAmount(), drop2.randomAmount(), annotation.replaceVanillaDrops(), allowedAges));
            }
            String string = allowedAges.isEmpty() ? "all ages" : "ages: " + String.join((CharSequence)", ", allowedAges);
            Atom.getInstance().getLogger().info("Registered " + annotation.drops().length + " custom drops for " + entityType.name() + " (" + string + ")");
        }
    }

    private Set<EntityType> getEntitiesFromCategory(CustomEntityDrops.EntityCategory category) {
        HashSet<EntityType> entities = new HashSet<EntityType>();
        for (EntityType type : EntityType.values()) {
            boolean matches;
            Class entityClass;
            if (!type.isSpawnable() || !type.isAlive() || (entityClass = type.getEntityClass()) == null) continue;
            switch (category) {
                default: {
                    throw new MatchException(null, null);
                }
                case ANIMALS: {
                    boolean bl = Animals.class.isAssignableFrom(entityClass);
                    break;
                }
                case MONSTERS: {
                    boolean bl = Monster.class.isAssignableFrom(entityClass);
                    break;
                }
                case WATER_MOBS: {
                    boolean bl = WaterMob.class.isAssignableFrom(entityClass);
                    break;
                }
                case AMBIENT: {
                    boolean bl = matches = Ambient.class.isAssignableFrom(entityClass);
                }
            }
            if (!matches) continue;
            entities.add(type);
        }
        Atom.getInstance().getLogger().info("Category " + String.valueOf((Object)category) + " matched " + entities.size() + " entity types");
        return entities;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDeath(EntityDeathEvent event) {
        Sheep sheep;
        LivingEntity entity = event.getEntity();
        EntityType entityType = entity.getType();
        if (!customDrops.containsKey(entityType)) {
            return;
        }
        List<DropConfigWithAge> drops = customDrops.get(entityType);
        String currentAge = Atom.getInstance().getAgeManager().getCurrentAge().getId();
        ArrayList<DropConfigWithAge> applicableDrops = new ArrayList<DropConfigWithAge>();
        boolean shouldReplaceVanilla = false;
        for (DropConfigWithAge drop2 : drops) {
            if (!drop2.allowedAges.isEmpty() && !drop2.allowedAges.contains(currentAge)) continue;
            applicableDrops.add(drop2);
            if (!drop2.replaceVanillaDrops) continue;
            shouldReplaceVanilla = true;
        }
        if (applicableDrops.isEmpty()) {
            return;
        }
        if (shouldReplaceVanilla) {
            event.getDrops().clear();
            event.setDroppedExp(random.nextInt(3) + 1);
        }
        String animalName = this.getAnimalDisplayName(entityType);
        String animalId = this.getAnimalId(entityType);
        AnimalType animalType = AnimalType.byId(animalId);
        if (animalType == null) {
            return;
        }
        for (DropConfigWithAge drop3 : applicableDrops) {
            int amount = drop3.minAmount;
            if (drop3.randomAmount && drop3.maxAmount > drop3.minAmount) {
                amount = drop3.minAmount + random.nextInt(drop3.maxAmount - drop3.minAmount + 1);
            }
            if (amount <= 0) continue;
            Object itemId = drop3.customItemId;
            if (drop3.customItemId.equals("bone")) {
                itemId = "atom:animal_bone_" + animalId;
            } else if (drop3.customItemId.equals("uncured_leather")) {
                itemId = "atom:animal_leather_raw_" + animalId;
            }
            ItemStack itemToDrop = null;
            try {
                CustomItem customItem = CraftEngineItems.byId((Key)Key.of((String)itemId));
                if (customItem != null) {
                    itemToDrop = (ItemStack)customItem.buildItemStack();
                }
            }
            catch (Exception e) {
                Atom.getInstance().getLogger().warning("Failed to create CraftEngine item: " + (String)itemId + " - " + e.getMessage());
            }
            if (itemToDrop != null) {
                itemToDrop.setAmount(amount);
                event.getDrops().add(itemToDrop);
                continue;
            }
            Atom.getInstance().getLogger().warning("Custom item not found: " + (String)itemId);
        }
        if (entityType == EntityType.SHEEP && !(sheep = (Sheep)entity).isSheared()) {
            DyeColor color = sheep.getColor();
            Material woolMaterial = switch (color) {
                default -> throw new MatchException(null, null);
                case DyeColor.WHITE -> Material.WHITE_WOOL;
                case DyeColor.ORANGE -> Material.ORANGE_WOOL;
                case DyeColor.MAGENTA -> Material.MAGENTA_WOOL;
                case DyeColor.LIGHT_BLUE -> Material.LIGHT_BLUE_WOOL;
                case DyeColor.YELLOW -> Material.YELLOW_WOOL;
                case DyeColor.LIME -> Material.LIME_WOOL;
                case DyeColor.PINK -> Material.PINK_WOOL;
                case DyeColor.GRAY -> Material.GRAY_WOOL;
                case DyeColor.LIGHT_GRAY -> Material.LIGHT_GRAY_WOOL;
                case DyeColor.CYAN -> Material.CYAN_WOOL;
                case DyeColor.PURPLE -> Material.PURPLE_WOOL;
                case DyeColor.BLUE -> Material.BLUE_WOOL;
                case DyeColor.BROWN -> Material.BROWN_WOOL;
                case DyeColor.GREEN -> Material.GREEN_WOOL;
                case DyeColor.RED -> Material.RED_WOOL;
                case DyeColor.BLACK -> Material.BLACK_WOOL;
            };
            ItemStack wool = new ItemStack(woolMaterial, 1);
            event.getDrops().add(wool);
        }
    }

    private String getAnimalDisplayName(EntityType type) {
        return switch (type) {
            case EntityType.COW -> "Cow";
            case EntityType.PIG -> "Pig";
            case EntityType.SHEEP -> "Sheep";
            case EntityType.CHICKEN -> "Chicken";
            case EntityType.RABBIT -> "Rabbit";
            case EntityType.HORSE -> "Horse";
            case EntityType.DONKEY -> "Donkey";
            case EntityType.MULE -> "Mule";
            case EntityType.LLAMA -> "Llama";
            case EntityType.GOAT -> "Goat";
            case EntityType.CAT -> "Cat";
            case EntityType.WOLF -> "Wolf";
            case EntityType.FOX -> "Fox";
            case EntityType.PANDA -> "Panda";
            case EntityType.POLAR_BEAR -> "Polar Bear";
            case EntityType.OCELOT -> "Ocelot";
            case EntityType.CAMEL -> "Camel";
            default -> type.name();
        };
    }

    @Nullable
    private String getAnimalId(EntityType type) {
        return switch (type) {
            case EntityType.COW -> "cow";
            case EntityType.PIG -> "pig";
            case EntityType.SHEEP -> "sheep";
            case EntityType.CHICKEN -> "chicken";
            case EntityType.RABBIT -> "rabbit";
            case EntityType.HORSE -> "horse";
            case EntityType.DONKEY -> "donkey";
            case EntityType.MULE -> "mule";
            case EntityType.LLAMA -> "llama";
            case EntityType.GOAT -> "goat";
            case EntityType.CAT -> "cat";
            case EntityType.WOLF -> "wolf";
            case EntityType.FOX -> "fox";
            case EntityType.PANDA -> "panda";
            case EntityType.POLAR_BEAR -> "polar_bear";
            case EntityType.OCELOT -> "ocelot";
            case EntityType.CAMEL -> "camel";
            default -> null;
        };
    }

    private static class DropConfigWithAge {
        final String customItemId;
        final int minAmount;
        final int maxAmount;
        final boolean randomAmount;
        final boolean replaceVanillaDrops;
        final Set<String> allowedAges;

        DropConfigWithAge(String customItemId, int minAmount, int maxAmount, boolean randomAmount, boolean replaceVanillaDrops, Set<String> allowedAges) {
            this.customItemId = customItemId;
            this.minAmount = minAmount;
            this.maxAmount = maxAmount;
            this.randomAmount = randomAmount;
            this.replaceVanillaDrops = replaceVanillaDrops;
            this.allowedAges = allowedAges;
        }
    }
}

