/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.blocks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;
import org.shotrush.atom.Atom;
import org.shotrush.atom.content.systems.ItemHeatSystem;
import org.shotrush.atom.core.api.item.QualityInheritanceAPI;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;
import org.shotrush.atom.core.blocks.CustomBlock;
import org.shotrush.atom.core.util.ActionBarManager;

public abstract class InteractiveSurface
extends CustomBlock {
    protected final List<PlacedItem> placedItems = new ArrayList<PlacedItem>();

    public InteractiveSurface(Location spawnLocation, Location blockLocation, BlockFace blockFace) {
        super(spawnLocation, blockLocation, blockFace);
    }

    public InteractiveSurface(Location spawnLocation, BlockFace blockFace) {
        super(spawnLocation, blockFace);
    }

    @Override
    public boolean onInteract(Player player, boolean sneaking) {
        if (this.useGuiMode() && !sneaking) {
            this.openGui(player);
            return true;
        }
        if (sneaking) {
            return this.onCrouchRightClick(player);
        }
        return false;
    }

    @Override
    public void spawn(Atom plugin) {
        if (this.spawnLocation.getWorld() == null) {
            plugin.getLogger().warning("Cannot spawn InteractiveSurface at " + String.valueOf(this.spawnLocation) + " - world is null");
            return;
        }
        plugin.getLogger().info(String.format("[InteractiveSurface] spawn() called for %s with %d placedItems", this.getIdentifier(), this.placedItems.size()));
        SchedulerAPI.runTask(this.spawnLocation, () -> {
            this.cleanupExistingEntities();
            this.spawn(plugin, (RegionAccessor)this.spawnLocation.getWorld());
            if (!this.placedItems.isEmpty()) {
                this.updateItemDisplayUUIDs();
            }
        });
    }

    public abstract int getMaxItems();

    public abstract boolean canPlaceItem(ItemStack var1);

    public abstract Vector3f calculatePlacement(Player var1, int var2);

    protected boolean useGuiMode() {
        return false;
    }

    protected void openGui(Player player) {
        player.openWorkbench(this.spawnLocation, true);
    }

    protected boolean onCrouchRightClick(Player player) {
        ItemStack result = this.checkRecipe();
        if (result != null) {
            this.clearAllItems();
            player.getWorld().dropItemNaturally(this.spawnLocation, result);
            ActionBarManager.send(player, "\u00a7aCrafted: " + result.getType().name());
            return true;
        }
        this.releaseAllItems(player);
        return true;
    }

    protected ItemStack checkRecipe() {
        return null;
    }

    protected void applyQualityInheritance(ItemStack result) {
        if (result == null || this.placedItems.isEmpty()) {
            return;
        }
        ItemStack[] ingredients = (ItemStack[])this.placedItems.stream().map(PlacedItem::getItem).toArray(ItemStack[]::new);
        QualityInheritanceAPI.applyInheritedQuality(result, ingredients);
    }

    protected void releaseAllItems(Player player) {
        if (this.placedItems.isEmpty()) {
            return;
        }
        for (PlacedItem placedItem : new ArrayList<PlacedItem>(this.placedItems)) {
            this.removeItemDisplay(placedItem);
            player.getWorld().dropItemNaturally(this.spawnLocation, placedItem.getItem());
        }
        this.placedItems.clear();
    }

    protected void clearAllItems() {
        for (PlacedItem placedItem : new ArrayList<PlacedItem>(this.placedItems)) {
            this.removeItemDisplay(placedItem);
        }
        this.placedItems.clear();
    }

    public boolean placeItem(ItemStack item, Vector3f position, float yaw) {
        if (this.placedItems.size() >= this.getMaxItems()) {
            return false;
        }
        if (!this.canPlaceItem(item)) {
            return false;
        }
        ItemStack singleItem = item.clone();
        singleItem.setAmount(1);
        PlacedItem placedItem = new PlacedItem(singleItem, position, yaw);
        this.placedItems.add(placedItem);
        this.spawnItemDisplay(placedItem);
        return true;
    }

    public boolean placeItem(Player player, ItemStack item, Vector3f position, float yaw) {
        if (this.placeItem(item, position, yaw)) {
            player.swingMainHand();
            return true;
        }
        return false;
    }

    public ItemStack removeLastItem() {
        if (this.placedItems.isEmpty()) {
            return null;
        }
        PlacedItem item = this.placedItems.remove(this.placedItems.size() - 1);
        this.removeItemDisplay(item);
        return item.getItem();
    }

    protected void spawnItemDisplay(PlacedItem item) {
        if (this.spawnLocation.getWorld() == null) {
            return;
        }
        Location displayLoc = this.spawnLocation.clone().add((double)item.getPosition().x, (double)item.getPosition().y, (double)item.getPosition().z);
        SchedulerAPI.runTask(displayLoc, () -> {
            ItemDisplay display = (ItemDisplay)displayLoc.getWorld().spawnEntity(displayLoc, EntityType.ITEM_DISPLAY);
            display.setItemStack(item.getItem());
            display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.NONE);
            display.setBillboard(Display.Billboard.FIXED);
            AxisAngle4f rotation = this.getItemDisplayRotation(item);
            Vector3f translation = this.getItemDisplayTranslation(item);
            Vector3f scale = this.getItemDisplayScale(item);
            Transformation transformation = new Transformation(translation, rotation, scale, new AxisAngle4f(0.0f, 0.0f, 0.0f, 1.0f));
            display.setTransformation(transformation);
            display.setViewRange(64.0f);
            display.setShadowRadius(0.0f);
            display.setShadowStrength(0.0f);
            if (this.interactionUUID != null) {
                display.getPersistentDataContainer().set(Objects.requireNonNull(NamespacedKey.fromString((String)"parent_workstation", (Plugin)Atom.getInstance())), PersistentDataType.STRING, (Object)this.interactionUUID.toString());
            }
            item.setDisplayUUID(display.getUniqueId());
            ItemHeatSystem.startItemDisplayHeatTracking(display);
        });
    }

    protected AxisAngle4f getItemDisplayRotation(PlacedItem item) {
        return new AxisAngle4f((float)Math.toRadians(90.0), 1.0f, 0.0f, 0.0f);
    }

    protected Vector3f getItemDisplayTranslation(PlacedItem item) {
        return new Vector3f(0.05f, 0.0f, 0.0f);
    }

    protected Vector3f getItemDisplayScale(PlacedItem item) {
        return new Vector3f(0.5f, 0.5f, 0.5f);
    }

    protected void removeItemDisplay(PlacedItem item) {
        Vector3f pos = item.getPosition();
        Location expectedLoc = this.spawnLocation.clone().add((double)pos.x, (double)pos.y, (double)pos.z);
        if (expectedLoc.getWorld() == null) {
            return;
        }
        SchedulerAPI.runTask(expectedLoc, () -> {
            for (Entity nearby : expectedLoc.getWorld().getNearbyEntities(expectedLoc, 0.5, 0.5, 0.5)) {
                String parentUUID;
                if (!(nearby instanceof ItemDisplay)) continue;
                ItemDisplay itemDisplay = (ItemDisplay)nearby;
                if (nearby.getUniqueId().equals(this.displayUUID) || (parentUUID = (String)itemDisplay.getPersistentDataContainer().get(Objects.requireNonNull(NamespacedKey.fromString((String)"parent_workstation", (Plugin)Atom.getInstance())), PersistentDataType.STRING)) != null && (this.interactionUUID == null || !parentUUID.equals(this.interactionUUID.toString()))) continue;
                nearby.remove();
            }
        });
    }

    public List<PlacedItem> getPlacedItems() {
        return new ArrayList<PlacedItem>(this.placedItems);
    }

    public void updateItemDisplayUUIDs() {
        if (this.spawnLocation.getWorld() == null) {
            return;
        }
        for (PlacedItem item : this.placedItems) {
            item.setDisplayUUID(null);
        }
        SchedulerAPI.runTask(this.spawnLocation, () -> {
            for (PlacedItem item : this.placedItems) {
                Vector3f pos = item.getPosition();
                Location itemLoc = this.spawnLocation.clone().add((double)pos.x, (double)pos.y, (double)pos.z);
                for (Entity entity : itemLoc.getWorld().getNearbyEntities(itemLoc, 0.2, 0.2, 0.2)) {
                    if (!(entity instanceof ItemDisplay)) continue;
                    entity.remove();
                }
            }
            SchedulerAPI.runTaskLater(this.spawnLocation, () -> {
                for (PlacedItem item : this.placedItems) {
                    this.spawnItemDisplay(item);
                }
            }, 5L);
        });
    }

    @Override
    protected String serializeAdditionalData() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.placedItems.size());
        for (PlacedItem item : this.placedItems) {
            try {
                String base64 = InteractiveSurface.itemToBase64(item.getItem());
                sb.append(";").append(base64).append(",").append(item.getPosition().x).append(",").append(item.getPosition().y).append(",").append(item.getPosition().z).append(",").append(item.getYaw());
            }
            catch (IOException e) {
                Atom.getInstance().getLogger().warning("Failed to serialize item: " + e.getMessage());
            }
        }
        return sb.toString();
    }

    @Override
    protected String deserializeAdditionalData(String[] parts, int startIndex) {
        if (startIndex >= parts.length) {
            return null;
        }
        try {
            int partIndex;
            int itemCount = Integer.parseInt(parts[startIndex]);
            for (int i = 0; i < itemCount && (partIndex = startIndex + 1 + i) < parts.length; ++i) {
                String[] itemData = parts[partIndex].split(",");
                String base64 = itemData[0];
                float x = Float.parseFloat(itemData[1]);
                float y = Float.parseFloat(itemData[2]);
                float z = Float.parseFloat(itemData[3]);
                float yaw = Float.parseFloat(itemData[4]);
                ItemStack item = InteractiveSurface.itemFromBase64(base64);
                Vector3f position = new Vector3f(x, y, z);
                this.placedItems.add(new PlacedItem(item, position, yaw));
            }
        }
        catch (Exception e) {
            Atom.getInstance().getLogger().warning("Failed to deserialize placed items: " + e.getMessage());
        }
        return null;
    }

    @Override
    protected void cleanupExistingEntities() {
        for (Entity entity : this.spawnLocation.getWorld().getNearbyEntities(this.spawnLocation, 0.5, 0.5, 0.5)) {
            if (!(entity instanceof ItemDisplay) && !(entity instanceof Interaction) || !(entity.getLocation().distance(this.spawnLocation) < 0.1)) continue;
            entity.remove();
        }
        for (Entity entity : this.spawnLocation.getWorld().getNearbyEntities(this.getBlockCenter(), 0.5, 0.6, 0.5)) {
            if (!(entity instanceof ItemDisplay) || !(entity.getLocation().distance(this.getBlockCenter()) <= 0.6)) continue;
            entity.remove();
        }
    }

    protected Location getBlockCenter() {
        return this.blockLocation.clone().add(0.5, 0.5, 0.5);
    }

    private static String itemToBase64(ItemStack item) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
        dataOutput.writeObject((Object)item);
        dataOutput.close();
        return Base64.getEncoder().encodeToString(outputStream.toByteArray());
    }

    private static ItemStack itemFromBase64(String base64) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(base64));
        BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
        ItemStack item = (ItemStack)dataInput.readObject();
        dataInput.close();
        return item;
    }

    public static class PlacedItem {
        private final ItemStack item;
        private final Vector3f position;
        private final float yaw;
        private UUID displayUUID;

        public PlacedItem(ItemStack item, Vector3f position, float yaw) {
            this.item = item;
            this.position = position;
            this.yaw = yaw;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public Vector3f getPosition() {
            return this.position;
        }

        public float getYaw() {
            return this.yaw;
        }

        public UUID getDisplayUUID() {
            return this.displayUUID;
        }

        @Generated
        public void setDisplayUUID(UUID displayUUID) {
            this.displayUUID = displayUUID;
        }
    }
}

