/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.blocks.util;

import org.bukkit.Location;
import org.bukkit.block.BlockFace;

public class BlockAxisUtil {
    public static Axis getAxis(BlockFace face) {
        return switch (face) {
            case BlockFace.UP, BlockFace.DOWN -> Axis.Y;
            case BlockFace.NORTH, BlockFace.SOUTH -> Axis.Z;
            case BlockFace.EAST, BlockFace.WEST -> Axis.X;
            default -> Axis.UNKNOWN;
        };
    }

    public static boolean isSameAxis(BlockFace face1, BlockFace face2) {
        return BlockAxisUtil.getAxis(face1) == BlockAxisUtil.getAxis(face2) && BlockAxisUtil.getAxis(face1) != Axis.UNKNOWN;
    }

    public static boolean isConnectedAlongAxis(Location loc1, Location loc2, Axis axis) {
        int dx = Math.abs(loc1.getBlockX() - loc2.getBlockX());
        int dy = Math.abs(loc1.getBlockY() - loc2.getBlockY());
        int dz = Math.abs(loc1.getBlockZ() - loc2.getBlockZ());
        return switch (axis.ordinal()) {
            case 1 -> {
                if (dy > 0 && dx == 0 && dz == 0) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (dz > 0 && dx == 0 && dy == 0) {
                    yield true;
                }
                yield false;
            }
            case 0 -> {
                if (dx > 0 && dy == 0 && dz == 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static Axis getPrimaryAxis(Location from, Location to) {
        int dx = Math.abs(from.getBlockX() - to.getBlockX());
        int dy = Math.abs(from.getBlockY() - to.getBlockY());
        int dz = Math.abs(from.getBlockZ() - to.getBlockZ());
        if (dx > dy && dx > dz) {
            return Axis.X;
        }
        if (dy > dx && dy > dz) {
            return Axis.Y;
        }
        if (dz > dx && dz > dy) {
            return Axis.Z;
        }
        return Axis.UNKNOWN;
    }

    public static int getAxisOffset(Location from, Location to, Axis axis) {
        return switch (axis.ordinal()) {
            case 0 -> to.getBlockX() - from.getBlockX();
            case 1 -> to.getBlockY() - from.getBlockY();
            case 2 -> to.getBlockZ() - from.getBlockZ();
            default -> 0;
        };
    }

    public static enum Axis {
        X,
        Y,
        Z,
        UNKNOWN;

    }
}

