/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.blocks.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.shotrush.atom.core.blocks.CustomBlock;
import org.shotrush.atom.core.blocks.util.BlockLocationUtil;

public class BlockNetworkUtil {
    public static <T extends CustomBlock> void breadthFirstSearch(List<CustomBlock> allBlocks, Class<T> blockType, Predicate<T> isSource, BiConsumer<T, Integer> onVisit) {
        List<CustomBlock> blocks = BlockNetworkUtil.filterBlocks(allBlocks, blockType);
        HashSet<CustomBlock> visited = new HashSet<CustomBlock>();
        LinkedList<BlockDepthPair<CustomBlock>> queue = new LinkedList<BlockDepthPair<CustomBlock>>();
        for (CustomBlock block : blocks) {
            if (!isSource.test(block)) continue;
            queue.add(new BlockDepthPair<CustomBlock>(block, 0));
            visited.add(block);
        }
        while (!queue.isEmpty()) {
            BlockDepthPair current = (BlockDepthPair)queue.poll();
            onVisit.accept((CustomBlock)current.block, current.depth);
            List<CustomBlock> adjacent = BlockLocationUtil.getAdjacentBlocks(((CustomBlock)current.block).getBlockLocation(), allBlocks, blockType);
            for (CustomBlock adj : adjacent) {
                if (visited.contains(adj)) continue;
                visited.add(adj);
                queue.add(new BlockDepthPair<CustomBlock>(adj, current.depth + 1));
            }
        }
    }

    public static <T extends CustomBlock, S> void breadthFirstSearchWithState(List<CustomBlock> allBlocks, Class<T> blockType, Predicate<T> isSource, Function<T, S> getInitialState, TriConsumer<T, S, List<T>> onVisit) {
        List<CustomBlock> blocks = BlockNetworkUtil.filterBlocks(allBlocks, blockType);
        HashSet<CustomBlock> visited = new HashSet<CustomBlock>();
        LinkedList<BlockStatePair<CustomBlock, S>> queue = new LinkedList<BlockStatePair<CustomBlock, S>>();
        for (CustomBlock block : blocks) {
            if (!isSource.test(block)) continue;
            S initialState = getInitialState.apply(block);
            queue.add(new BlockStatePair<CustomBlock, S>(block, initialState));
            visited.add(block);
        }
        while (!queue.isEmpty()) {
            BlockStatePair current = (BlockStatePair)queue.poll();
            List<CustomBlock> adjacent = BlockLocationUtil.getAdjacentBlocks(((CustomBlock)current.block).getBlockLocation(), allBlocks, blockType);
            onVisit.accept((CustomBlock)current.block, current.state, adjacent);
            for (CustomBlock adj : adjacent) {
                if (visited.contains(adj)) continue;
                visited.add(adj);
            }
        }
    }

    public static <T extends CustomBlock> List<T> filterBlocks(List<CustomBlock> allBlocks, Class<T> blockType) {
        ArrayList<CustomBlock> filtered = new ArrayList<CustomBlock>();
        for (CustomBlock block : allBlocks) {
            if (!blockType.isInstance(block)) continue;
            filtered.add((CustomBlock)blockType.cast(block));
        }
        return filtered;
    }

    public static <T extends CustomBlock> Set<T> findConnectedNetwork(T startBlock, List<CustomBlock> allBlocks, Class<T> blockType) {
        HashSet<CustomBlock> network = new HashSet<CustomBlock>();
        LinkedList<CustomBlock> queue = new LinkedList<CustomBlock>();
        queue.add(startBlock);
        network.add(startBlock);
        while (!queue.isEmpty()) {
            CustomBlock current = (CustomBlock)queue.poll();
            List<CustomBlock> adjacent = BlockLocationUtil.getAdjacentBlocks(current.getBlockLocation(), allBlocks, blockType);
            for (CustomBlock adj : adjacent) {
                if (network.contains(adj)) continue;
                network.add(adj);
                queue.add(adj);
            }
        }
        return network;
    }

    private static class BlockDepthPair<T> {
        final T block;
        final int depth;

        BlockDepthPair(T block, int depth) {
            this.block = block;
            this.depth = depth;
        }
    }

    private static class BlockStatePair<T, S> {
        final T block;
        final S state;

        BlockStatePair(T block, S state) {
            this.block = block;
            this.state = state;
        }
    }

    @FunctionalInterface
    public static interface TriConsumer<A, B, C> {
        public void accept(A var1, B var2, C var3);
    }
}

