/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.blocks.util;

import org.bukkit.block.BlockFace;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class BlockRotationUtil {
    public static AxisAngle4f getInitialRotationFromFace(BlockFace face) {
        switch (face) {
            case UP: 
            case DOWN: {
                return new AxisAngle4f();
            }
            case NORTH: 
            case SOUTH: {
                return new AxisAngle4f(1.5707964f, 1.0f, 0.0f, 0.0f);
            }
            case WEST: 
            case EAST: {
                return new AxisAngle4f(1.5707964f, 0.0f, 0.0f, 1.0f);
            }
        }
        return new AxisAngle4f();
    }

    public static AxisAngle4f combineRotations(AxisAngle4f first2, AxisAngle4f second2) {
        Quaternionf q1 = new Quaternionf().rotateAxis(first2.angle, first2.x, first2.y, first2.z);
        Quaternionf q2 = new Quaternionf().rotateAxis(second2.angle, second2.x, second2.y, second2.z);
        q1.mul((Quaternionfc)q2);
        AxisAngle4f result = new AxisAngle4f();
        q1.get(result);
        return result;
    }

    public static Axis getAxis(BlockFace face) {
        return switch (face) {
            case BlockFace.UP, BlockFace.DOWN -> Axis.Y;
            case BlockFace.NORTH, BlockFace.SOUTH -> Axis.Z;
            case BlockFace.WEST, BlockFace.EAST -> Axis.X;
            default -> Axis.UNKNOWN;
        };
    }

    public static boolean isSameAxis(BlockFace face1, BlockFace face2) {
        return BlockRotationUtil.getAxis(face1) == BlockRotationUtil.getAxis(face2);
    }

    public static enum Axis {
        X,
        Y,
        Z,
        UNKNOWN;

    }
}

