/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.data;

import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public class PersistentData {
    private static final String NAMESPACE = "atom";

    public static NamespacedKey key(String key) {
        return new NamespacedKey(NAMESPACE, key);
    }

    public static void set(PersistentDataHolder holder, String key, byte value) {
        holder.getPersistentDataContainer().set(PersistentData.key(key), PersistentDataType.BYTE, (Object)value);
    }

    public static void set(PersistentDataHolder holder, String key, short value) {
        holder.getPersistentDataContainer().set(PersistentData.key(key), PersistentDataType.SHORT, (Object)value);
    }

    public static void set(PersistentDataHolder holder, String key, int value) {
        holder.getPersistentDataContainer().set(PersistentData.key(key), PersistentDataType.INTEGER, (Object)value);
    }

    public static void set(PersistentDataHolder holder, String key, long value) {
        holder.getPersistentDataContainer().set(PersistentData.key(key), PersistentDataType.LONG, (Object)value);
    }

    public static void set(PersistentDataHolder holder, String key, float value) {
        holder.getPersistentDataContainer().set(PersistentData.key(key), PersistentDataType.FLOAT, (Object)Float.valueOf(value));
    }

    public static void set(PersistentDataHolder holder, String key, double value) {
        holder.getPersistentDataContainer().set(PersistentData.key(key), PersistentDataType.DOUBLE, (Object)value);
    }

    public static void set(PersistentDataHolder holder, String key, String value) {
        holder.getPersistentDataContainer().set(PersistentData.key(key), PersistentDataType.STRING, (Object)value);
    }

    public static void set(PersistentDataHolder holder, String key, boolean value) {
        holder.getPersistentDataContainer().set(PersistentData.key(key), PersistentDataType.BYTE, (Object)((byte)(value ? 1 : 0)));
    }

    public static byte getByte(PersistentDataHolder holder, String key, byte defaultValue) {
        return (Byte)holder.getPersistentDataContainer().getOrDefault(PersistentData.key(key), PersistentDataType.BYTE, (Object)defaultValue);
    }

    public static short getShort(PersistentDataHolder holder, String key, short defaultValue) {
        return (Short)holder.getPersistentDataContainer().getOrDefault(PersistentData.key(key), PersistentDataType.SHORT, (Object)defaultValue);
    }

    public static int getInt(PersistentDataHolder holder, String key, int defaultValue) {
        return (Integer)holder.getPersistentDataContainer().getOrDefault(PersistentData.key(key), PersistentDataType.INTEGER, (Object)defaultValue);
    }

    public static long getLong(PersistentDataHolder holder, String key, long defaultValue) {
        return (Long)holder.getPersistentDataContainer().getOrDefault(PersistentData.key(key), PersistentDataType.LONG, (Object)defaultValue);
    }

    public static float getFloat(PersistentDataHolder holder, String key, float defaultValue) {
        return ((Float)holder.getPersistentDataContainer().getOrDefault(PersistentData.key(key), PersistentDataType.FLOAT, (Object)Float.valueOf(defaultValue))).floatValue();
    }

    public static double getDouble(PersistentDataHolder holder, String key, double defaultValue) {
        return (Double)holder.getPersistentDataContainer().getOrDefault(PersistentData.key(key), PersistentDataType.DOUBLE, (Object)defaultValue);
    }

    public static String getString(PersistentDataHolder holder, String key, String defaultValue) {
        return (String)holder.getPersistentDataContainer().getOrDefault(PersistentData.key(key), PersistentDataType.STRING, (Object)defaultValue);
    }

    public static boolean getBoolean(PersistentDataHolder holder, String key, boolean defaultValue) {
        return PersistentData.getByte(holder, key, (byte)(defaultValue ? 1 : 0)) == 1;
    }

    public static boolean has(PersistentDataHolder holder, String key) {
        return holder.getPersistentDataContainer().has(PersistentData.key(key));
    }

    public static void remove(PersistentDataHolder holder, String key) {
        holder.getPersistentDataContainer().remove(PersistentData.key(key));
    }

    public static void flag(PersistentDataHolder holder, String key) {
        PersistentData.set(holder, key, true);
    }

    public static boolean isFlagged(PersistentDataHolder holder, String key) {
        return PersistentData.has(holder, key);
    }
}

