/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.items;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.core.items.CustomItem;

public class CustomItemRegistry {
    private final Plugin plugin;
    private final Map<String, CustomItem> items = new HashMap<String, CustomItem>();

    public CustomItemRegistry(Plugin plugin) {
        this.plugin = plugin;
    }

    public void register(CustomItem item) {
        this.items.put(item.getIdentifier(), item);
        this.plugin.getLogger().info("Registered custom item: " + item.getIdentifier());
    }

    public CustomItem getItem(String identifier) {
        return this.items.get(identifier);
    }

    public CustomItem getItem(ItemStack itemStack) {
        for (CustomItem item : this.items.values()) {
            if (!item.isCustomItem(itemStack)) continue;
            return item;
        }
        return null;
    }

    public CustomItem getCustomItem(ItemStack itemStack) {
        return this.getItem(itemStack);
    }

    public ItemStack createItem(String identifier) {
        CustomItem item = this.items.get(identifier);
        return item != null ? item.create() : null;
    }

    public Collection<CustomItem> getAllItems() {
        return this.items.values();
    }

    public Set<String> getAllIdentifiers() {
        return this.items.keySet();
    }
}

