/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.items;

import lombok.Generated;

public enum ItemQuality {
    LOW("\u00a77Low Quality", 0.5, 0.5, 1.5),
    MEDIUM("\u00a7fMedium Quality", 0.75, 0.75, 1.2),
    HIGH("\u00a7aHigh Quality", 1.0, 1.0, 1.0);

    private final String displayName;
    private final double efficiencyMultiplier;
    private final double durabilityMultiplier;
    private final double processingCostMultiplier;

    private ItemQuality(String displayName, double efficiencyMultiplier, double durabilityMultiplier, double processingCostMultiplier) {
        this.displayName = displayName;
        this.efficiencyMultiplier = efficiencyMultiplier;
        this.durabilityMultiplier = durabilityMultiplier;
        this.processingCostMultiplier = processingCostMultiplier;
    }

    public static ItemQuality fromTemperature(double temperature) {
        if (temperature < 15.0) {
            return LOW;
        }
        if (temperature > 25.0) {
            return LOW;
        }
        double deviation = Math.abs(temperature - 20.0);
        if (deviation <= 2.0) {
            return HIGH;
        }
        return MEDIUM;
    }

    public static ItemQuality average(ItemQuality ... qualities) {
        if (qualities == null || qualities.length == 0) {
            return MEDIUM;
        }
        int totalValue = 0;
        int count2 = 0;
        for (ItemQuality quality : qualities) {
            if (quality == null) continue;
            totalValue += quality.ordinal();
            ++count2;
        }
        if (count2 == 0) {
            return MEDIUM;
        }
        double average = (double)totalValue / (double)count2;
        if (average < 0.5) {
            return LOW;
        }
        if (average > 1.5) {
            return HIGH;
        }
        return MEDIUM;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public double getEfficiencyMultiplier() {
        return this.efficiencyMultiplier;
    }

    @Generated
    public double getDurabilityMultiplier() {
        return this.durabilityMultiplier;
    }

    @Generated
    public double getProcessingCostMultiplier() {
        return this.processingCostMultiplier;
    }
}

