/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.projectiles;

import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.shotrush.atom.Atom;

public class CustomProjectile {
    private static final double DEFAULT_GRAVITY = 0.03;
    private static final double DEFAULT_AIR_DRAG = 0.99;
    private static final int DEFAULT_MAX_LIFETIME = 200;
    private final Atom plugin;
    private final ItemDisplay display;
    private final Vector velocity;
    private final ItemStack projectileItem;
    private final Player shooter;
    private final ProjectileConfig config;
    private int ticksAlive = 0;
    private boolean isActive = true;
    private Consumer<RayTraceResult> onBlockHit;
    private Consumer<LivingEntity> onEntityHit;
    private Runnable onExpire;

    public CustomProjectile(Atom plugin, Location startLocation, Vector initialVelocity, ItemStack displayItem, ItemStack projectileItem, Player shooter, ProjectileConfig config) {
        this.plugin = plugin;
        this.velocity = initialVelocity.clone();
        this.projectileItem = projectileItem;
        this.shooter = shooter;
        this.config = config;
        this.display = (ItemDisplay)startLocation.getWorld().spawnEntity(startLocation, EntityType.ITEM_DISPLAY);
        this.display.setItemStack(displayItem);
        this.display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.NONE);
        this.display.setBillboard(Display.Billboard.FIXED);
        this.display.setViewRange(config.viewRange);
        this.display.setShadowRadius(0.0f);
        this.display.setShadowStrength(0.0f);
        this.display.setInterpolationDuration(config.interpolationDuration);
        this.display.setInterpolationDelay(config.interpolationDelay);
        if (config.baseRotation != null) {
            AxisAngle4f baseAxis = new AxisAngle4f();
            config.baseRotation.get(baseAxis);
            this.display.setTransformation(new Transformation(config.translation, baseAxis, config.scale, new AxisAngle4f(0.0f, 0.0f, 0.0f, 1.0f)));
        }
    }

    public void start() {
        this.display.getScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
            if (!this.update()) {
                task.cancel();
            }
        }, null, 1L, 1L);
    }

    private boolean update() {
        if (!this.display.isValid() || !this.isActive) {
            this.cleanup();
            return false;
        }
        ++this.ticksAlive;
        if (this.ticksAlive >= this.config.maxLifetime) {
            if (this.onExpire != null) {
                this.onExpire.run();
            } else {
                this.display.getLocation().getWorld().dropItemNaturally(this.display.getLocation(), this.projectileItem);
            }
            this.cleanup();
            return false;
        }
        Location currentLoc = this.display.getLocation();
        RayTraceResult blockHit = currentLoc.getWorld().rayTraceBlocks(currentLoc, this.velocity.clone().normalize(), this.velocity.length() + 0.3, FluidCollisionMode.NEVER, true);
        if (blockHit != null && blockHit.getHitBlock() != null) {
            if (this.onBlockHit != null) {
                this.onBlockHit.accept(blockHit);
            } else {
                Location hitLoc = blockHit.getHitPosition().toLocation(currentLoc.getWorld());
                hitLoc.getWorld().dropItemNaturally(hitLoc, this.projectileItem);
            }
            this.cleanup();
            return false;
        }
        RayTraceResult entityHit = currentLoc.getWorld().rayTraceEntities(currentLoc, this.velocity.clone().normalize(), this.velocity.length() + 0.3, 0.3, entity -> entity instanceof LivingEntity && entity != this.shooter && entity != this.display);
        if (entityHit != null && entityHit.getHitEntity() != null) {
            LivingEntity hitEntity = (LivingEntity)entityHit.getHitEntity();
            if (this.onEntityHit != null) {
                this.onEntityHit.accept(hitEntity);
            } else {
                hitEntity.damage(this.config.damage, (Entity)this.shooter);
                Location hitLoc = entityHit.getHitPosition().toLocation(currentLoc.getWorld());
                hitLoc.getWorld().dropItemNaturally(hitLoc, this.projectileItem);
            }
            this.cleanup();
            return false;
        }
        Location nextLoc = currentLoc.clone().add(this.velocity);
        double speed = this.velocity.length();
        int dynamicInterpolation = (int)Math.ceil(speed * 3.0);
        dynamicInterpolation = Math.max(1, Math.min(10, dynamicInterpolation));
        this.display.setInterpolationDuration(dynamicInterpolation);
        this.display.setInterpolationDelay(0);
        this.display.teleportAsync(nextLoc);
        this.velocity.multiply(this.config.airDrag);
        this.velocity.setY(this.velocity.getY() - this.config.gravity);
        this.updateRotation();
        return true;
    }

    private void updateRotation() {
        if (this.velocity.lengthSquared() < 1.0E-4) {
            return;
        }
        Vector normalized = this.velocity.clone().normalize();
        float yaw = (float)Math.toDegrees(Math.atan2(-normalized.getX(), normalized.getZ()));
        float pitch = (float)Math.toDegrees(Math.asin(-normalized.getY()));
        Location loc = this.display.getLocation();
        loc.setYaw(yaw);
        loc.setPitch(pitch);
        this.display.teleportAsync(loc);
    }

    private void cleanup() {
        this.isActive = false;
        if (this.display != null && this.display.isValid()) {
            this.display.remove();
        }
    }

    public CustomProjectile onBlockHit(Consumer<RayTraceResult> handler) {
        this.onBlockHit = handler;
        return this;
    }

    public CustomProjectile onEntityHit(Consumer<LivingEntity> handler) {
        this.onEntityHit = handler;
        return this;
    }

    public CustomProjectile onExpire(Runnable handler) {
        this.onExpire = handler;
        return this;
    }

    public UUID getDisplayId() {
        return this.display.getUniqueId();
    }

    public ItemDisplay getDisplay() {
        return this.display;
    }

    public Vector getVelocity() {
        return this.velocity.clone();
    }

    public Player getShooter() {
        return this.shooter;
    }

    public static class ProjectileConfig {
        private double gravity = 0.03;
        private double airDrag = 0.99;
        private int maxLifetime = 200;
        private double damage = 8.0;
        private float viewRange = 128.0f;
        private int interpolationDuration = 5;
        private int interpolationDelay = -1;
        private Quaternionf baseRotation = null;
        private Vector3f translation = new Vector3f(0.0f, 0.0f, 0.0f);
        private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);

        public ProjectileConfig gravity(double gravity) {
            this.gravity = gravity;
            return this;
        }

        public ProjectileConfig airDrag(double airDrag) {
            this.airDrag = airDrag;
            return this;
        }

        public ProjectileConfig maxLifetime(int ticks) {
            this.maxLifetime = ticks;
            return this;
        }

        public ProjectileConfig damage(double damage) {
            this.damage = damage;
            return this;
        }

        public ProjectileConfig viewRange(float range) {
            this.viewRange = range;
            return this;
        }

        public ProjectileConfig interpolation(int duration, int delay) {
            this.interpolationDuration = duration;
            this.interpolationDelay = delay;
            return this;
        }

        public ProjectileConfig baseRotation(Quaternionf rotation) {
            this.baseRotation = rotation;
            return this;
        }

        public ProjectileConfig translation(float x, float y, float z) {
            this.translation = new Vector3f(x, y, z);
            return this;
        }

        public ProjectileConfig scale(float scale) {
            this.scale = new Vector3f(scale, scale, scale);
            return this;
        }

        public ProjectileConfig scale(float x, float y, float z) {
            this.scale = new Vector3f(x, y, z);
            return this;
        }
    }
}

