/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.recipe;

import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;
import org.shotrush.atom.core.data.PersistentData;

public class CustomItemChoice
extends RecipeChoice.ExactChoice {
    private final ItemStack template;

    public CustomItemChoice(@NotNull ItemStack template) {
        super(CustomItemChoice.removeHeatFromItem(template.clone()));
        this.template = CustomItemChoice.removeHeatFromItem(template.clone());
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.template.clone();
    }

    @NotNull
    public RecipeChoice.ExactChoice clone() {
        return new CustomItemChoice(this.template);
    }

    public boolean test(@NotNull ItemStack itemStack) {
        if (itemStack.getType() != this.template.getType()) {
            return false;
        }
        ItemStack testItem = CustomItemChoice.removeHeatFromItem(itemStack.clone());
        ItemStack templateItem = this.template.clone();
        return testItem.isSimilar(templateItem);
    }

    private static ItemStack removeHeatFromItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        PersistentData.remove((PersistentDataHolder)meta, "item_heat");
        item.setItemMeta(meta);
        return item;
    }
}

