/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.storage;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class DataStorage {
    private final Plugin plugin;
    private final File playerDataFolder;
    private final File serverDataFile;

    public DataStorage(Plugin plugin) {
        this.plugin = plugin;
        this.playerDataFolder = new File(plugin.getDataFolder(), "playerdata");
        this.serverDataFile = new File(plugin.getDataFolder(), "serverdata.yml");
        if (!this.playerDataFolder.exists()) {
            this.playerDataFolder.mkdirs();
        }
    }

    public YamlConfiguration getPlayerData(UUID uuid) {
        File playerFile = new File(this.playerDataFolder, uuid.toString() + ".yml");
        if (!playerFile.exists()) {
            try {
                playerFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to create player data file for " + String.valueOf(uuid));
            }
        }
        return YamlConfiguration.loadConfiguration((File)playerFile);
    }

    public void savePlayerData(UUID uuid, YamlConfiguration config) {
        File playerFile = new File(this.playerDataFolder, uuid.toString() + ".yml");
        try {
            config.save(playerFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save player data for " + String.valueOf(uuid));
        }
    }

    public YamlConfiguration getServerData() {
        if (!this.serverDataFile.exists()) {
            try {
                this.serverDataFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to create server data file");
            }
        }
        return YamlConfiguration.loadConfiguration((File)this.serverDataFile);
    }

    public void saveServerData(YamlConfiguration config) {
        try {
            config.save(this.serverDataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save server data");
        }
    }

    public boolean hasPlayerData(UUID uuid) {
        File playerFile = new File(this.playerDataFolder, uuid.toString() + ".yml");
        return playerFile.exists();
    }

    public void deletePlayerData(UUID uuid) {
        File playerFile = new File(this.playerDataFolder, uuid.toString() + ".yml");
        if (playerFile.exists()) {
            playerFile.delete();
        }
    }
}

