/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.util;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.core.api.annotation.RegisterSystem;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;

@RegisterSystem(id="action_bar_manager", priority=0, toggleable=false, description="Manages action bar messages for players")
public class ActionBarManager {
    private static ActionBarManager instance;
    private final Plugin plugin;
    private final Map<UUID, Map<String, String>> playerMessages = new ConcurrentHashMap<UUID, Map<String, String>>();
    private final Map<String, ScheduledTask> scheduledTasks = new HashMap<String, ScheduledTask>();
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().character('&').hexColors().build();
    private final LegacyComponentSerializer sectionSerializer = LegacyComponentSerializer.legacySection();

    public ActionBarManager(Plugin plugin) {
        this.plugin = plugin;
        instance = this;
        this.startActionBarTick();
    }

    public void setMessage(Player player, String key, String message) {
        this.playerMessages.computeIfAbsent(player.getUniqueId(), k -> new ConcurrentHashMap()).put(key, message);
    }

    public void removeMessage(Player player, String key) {
        Map<String, String> messages = this.playerMessages.get(player.getUniqueId());
        if (messages != null) {
            messages.remove(key);
        }
    }

    public void clearMessages(Player player) {
        this.playerMessages.remove(player.getUniqueId());
    }

    public static void send(Player player, String message) {
        ActionBarManager.send(player, message, 3);
    }

    public static void send(Player player, String key, String message) {
        ActionBarManager.send(player, key, message, 3);
    }

    public static void send(Player player, String message, int durationSeconds) {
        if (instance == null) {
            return;
        }
        String tempKey = "temp_" + System.currentTimeMillis() + "_" + message.hashCode();
        ActionBarManager.send(player, tempKey, message, durationSeconds);
    }

    public static void send(Player player, String key, String message, int durationSeconds) {
        if (instance == null) {
            return;
        }
        instance.setMessage(player, key, message);
        ScheduledTask task = SchedulerAPI.runTaskLater(player.getLocation(), () -> instance.removeMessage(player, key), (long)durationSeconds * 20L);
        ScheduledTask old = ActionBarManager.instance.scheduledTasks.put(key, task);
        if (old != null) {
            old.cancel();
        }
    }

    public static void sendStatus(Player player, String message) {
        if (instance == null) {
            return;
        }
        instance.setMessage(player, "status", message);
    }

    public static void clearStatus(Player player) {
        if (instance == null) {
            return;
        }
        instance.removeMessage(player, "status");
    }

    private Component parseMessage(String message) {
        if (message == null || message.isEmpty()) {
            return Component.empty();
        }
        if (message.contains("\u00a7")) {
            return this.sectionSerializer.deserialize(message);
        }
        if (message.contains("&")) {
            return this.legacySerializer.deserialize(message);
        }
        if (message.contains("<") && message.contains(">")) {
            try {
                return this.miniMessage.deserialize(message);
            }
            catch (Exception e) {
                return Component.text(message);
            }
        }
        return Component.text(message);
    }

    private void startActionBarTick() {
        SchedulerAPI.runGlobalTaskTimer(() -> {
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                this.updateActionBar(player);
            }
        }, 1L, 5L);
    }

    /*
     * WARNING - void declaration
     */
    private void updateActionBar(Player player) {
        Map<String, String> messages = this.playerMessages.get(player.getUniqueId());
        if (messages == null || messages.isEmpty()) {
            return;
        }
        ArrayList<Component> orderedComponents = new ArrayList<Component>();
        Object separator = this.miniMessage.deserialize(" <dark_gray>|</dark_gray> ");
        Object bulletSeparator = this.miniMessage.deserialize(" <dark_gray>\u2022</dark_gray> ");
        if (messages.containsKey("status")) {
            orderedComponents.add(this.parseMessage(messages.get("status")));
        }
        LinkedHashSet<String> uniqueTempMessages = new LinkedHashSet<String>();
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            if (!entry.getKey().startsWith("temp_")) continue;
            uniqueTempMessages.add(entry.getValue());
        }
        if (!uniqueTempMessages.isEmpty()) {
            if (uniqueTempMessages.size() == 1) {
                orderedComponents.add(this.parseMessage((String)uniqueTempMessages.iterator().next()));
            } else {
                Object combined = Component.empty();
                Iterator iterator2 = uniqueTempMessages.iterator();
                while (iterator2.hasNext()) {
                    combined = combined.append(this.parseMessage((String)iterator2.next()));
                    if (!iterator2.hasNext()) continue;
                    combined = combined.append((Component)bulletSeparator);
                }
                orderedComponents.add((Component)combined);
            }
        }
        if (messages.containsKey("body_temp")) {
            orderedComponents.add(this.parseMessage(messages.get("body_temp")));
        }
        if (messages.containsKey("item_heat")) {
            orderedComponents.add(this.parseMessage(messages.get("item_heat")));
        }
        if (messages.containsKey("thirst")) {
            orderedComponents.add(this.parseMessage(messages.get("thirst")));
        }
        for (Map.Entry entry : messages.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("body_temp") || key.equals("item_heat") || key.equals("thirst") || key.equals("status") || key.startsWith("temp_")) continue;
            orderedComponents.add(this.parseMessage((String)entry.getValue()));
        }
        if (!orderedComponents.isEmpty()) {
            void var8_14;
            Component finalComponent = (Component)orderedComponents.get(0);
            boolean bl = true;
            while (var8_14 < orderedComponents.size()) {
                finalComponent = finalComponent.append((Component)separator).append((Component)orderedComponents.get((int)var8_14));
                ++var8_14;
            }
            player.sendActionBar(finalComponent);
        }
    }

    @Generated
    public static ActionBarManager getInstance() {
        return instance;
    }
}

