/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.util;

import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.shotrush.atom.core.items.ItemQuality;

public class DurabilityUtil {
    public static void applyQualityBasedDamage(ItemStack item, ItemQuality quality) {
        ItemMeta itemMeta;
        if (item == null || !((itemMeta = item.getItemMeta()) instanceof Damageable)) {
            return;
        }
        Damageable damageable = (Damageable)itemMeta;
        double durabilityMultiplier = quality != null ? quality.getDurabilityMultiplier() : 0.75;
        double damageChance = 1.0 - durabilityMultiplier * 0.5;
        if (Math.random() < damageChance) {
            short maxDurability;
            int currentDamage = damageable.getDamage();
            if (currentDamage + 1 >= (maxDurability = item.getType().getMaxDurability())) {
                item.setAmount(0);
            } else {
                damageable.setDamage(currentDamage + 1);
                item.setItemMeta((ItemMeta)damageable);
            }
        }
    }

    public static boolean damage(ItemStack item, int amount) {
        ItemMeta itemMeta;
        if (item == null || !((itemMeta = item.getItemMeta()) instanceof Damageable)) {
            return false;
        }
        Damageable damageable = (Damageable)itemMeta;
        int currentDamage = damageable.getDamage();
        short maxDurability = item.getType().getMaxDurability();
        if (currentDamage + amount >= maxDurability) {
            item.setAmount(0);
            return true;
        }
        damageable.setDamage(currentDamage + amount);
        item.setItemMeta((ItemMeta)damageable);
        return false;
    }

    public static int getRemainingDurability(ItemStack item) {
        ItemMeta itemMeta;
        if (item == null || !((itemMeta = item.getItemMeta()) instanceof Damageable)) {
            return -1;
        }
        Damageable damageable = (Damageable)itemMeta;
        int currentDamage = damageable.getDamage();
        short maxDurability = item.getType().getMaxDurability();
        return maxDurability - currentDamage;
    }

    public static double getDurabilityPercentage(ItemStack item) {
        ItemMeta itemMeta;
        if (item == null || !((itemMeta = item.getItemMeta()) instanceof Damageable)) {
            return -1.0;
        }
        Damageable damageable = (Damageable)itemMeta;
        int currentDamage = damageable.getDamage();
        short maxDurability = item.getType().getMaxDurability();
        if (maxDurability == 0) {
            return 1.0;
        }
        return 1.0 - (double)currentDamage / (double)maxDurability;
    }
}

