/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.util;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.core.api.annotation.RegisterSystem;

@RegisterSystem(id="right_click_detector", priority=0, toggleable=false, description="Detects and tracks player right-click events")
public class RightClickDetector
implements Listener {
    private static final Map<UUID, ClickData> clickData = new ConcurrentHashMap<UUID, ClickData>();
    private static final long ALLOW_INTERVAL_MS = 1000L;

    public RightClickDetector(Plugin plugin) {
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onInteract(PlayerInteractEvent event) {
        if (event.getAction().isRightClick()) {
            UUID playerId = event.getPlayer().getUniqueId();
            ClickData data = clickData.computeIfAbsent(playerId, k -> new ClickData());
            data.lastClickTime = System.currentTimeMillis();
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        clickData.remove(event.getPlayer().getUniqueId());
    }

    public static boolean isRightClicking(UUID playerId) {
        ClickData data = clickData.get(playerId);
        if (data == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        return currentTime - data.lastClickTime <= 1500L;
    }

    public static void clear(UUID playerId) {
        clickData.remove(playerId);
    }

    private static class ClickData {
        long lastAllowTime = 0L;
        long lastClickTime = 0L;

        private ClickData() {
        }
    }
}

