/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.workstations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.util.Transformation;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;
import org.shotrush.atom.content.systems.ItemHeatSystem;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;
import org.shotrush.atom.core.data.PersistentData;
import org.shotrush.atom.core.workstations.WorkstationHandler;

public class WorkstationData {
    private static final Map<String, WorkstationHandler<?>> handlers = new HashMap();
    private final Location blockLocation;
    private final String workstationType;
    private final List<PlacedItem> placedItems = new ArrayList<PlacedItem>();

    public static void registerHandler(String type, WorkstationHandler<?> handler) {
        handlers.put(type, handler);
    }

    public static WorkstationHandler<?> getHandler(String type) {
        return handlers.get(type);
    }

    public WorkstationData(Location blockLocation, String workstationType) {
        this.blockLocation = blockLocation;
        this.workstationType = workstationType;
    }

    public boolean placeItem(ItemStack item, Vector3f position, float yaw) {
        ItemStack singleItem = item.clone();
        singleItem.setAmount(1);
        PlacedItem placedItem = new PlacedItem(singleItem, position, yaw);
        this.placedItems.add(placedItem);
        this.spawnItemDisplay(placedItem);
        return true;
    }

    public ItemStack removeLastItem() {
        if (this.placedItems.isEmpty()) {
            return null;
        }
        PlacedItem item = this.placedItems.remove(this.placedItems.size() - 1);
        this.removeItemDisplay(item);
        return item.getItem();
    }

    public void clearAllItems() {
        for (PlacedItem item : new ArrayList<PlacedItem>(this.placedItems)) {
            this.removeItemDisplay(item);
        }
        this.placedItems.clear();
    }

    private void spawnItemDisplay(PlacedItem item) {
        if (this.blockLocation.getWorld() == null) {
            return;
        }
        Location center = this.blockLocation.clone().add(0.5, 0.5, 0.5);
        Location displayLoc = center.clone().add((double)item.getPosition().x, (double)item.getPosition().y, (double)item.getPosition().z);
        SchedulerAPI.runTask(displayLoc, () -> {
            ItemDisplay display = (ItemDisplay)displayLoc.getWorld().spawnEntity(displayLoc, EntityType.ITEM_DISPLAY);
            display.setItemStack(item.getItem());
            display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.NONE);
            display.setBillboard(Display.Billboard.FIXED);
            String locationKey = "Workstation_" + this.workstationType + "_" + this.blockLocation.getBlockX() + "_" + this.blockLocation.getBlockY() + "_" + this.blockLocation.getBlockZ();
            PersistentData.set((PersistentDataHolder)display, "workstation_id", locationKey);
            WorkstationHandler<?> handler = handlers.get(this.workstationType);
            AxisAngle4f rotation = handler != null ? handler.getItemRotation() : new AxisAngle4f((float)Math.toRadians(90.0), 1.0f, 0.0f, 0.0f);
            Vector3f scale = handler != null ? handler.getItemScale() : new Vector3f(0.5f, 0.5f, 0.5f);
            Transformation transformation = new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), rotation, scale, new AxisAngle4f(0.0f, 0.0f, 0.0f, 1.0f));
            display.setTransformation(transformation);
            display.setViewRange(64.0f);
            display.setShadowRadius(0.0f);
            display.setShadowStrength(0.0f);
            item.setDisplayUUID(display.getUniqueId());
            ItemHeatSystem.startItemDisplayHeatTracking(display);
        });
    }

    private void removeItemDisplay(PlacedItem item) {
        if (this.blockLocation.getWorld() == null) {
            return;
        }
        String locationKey = "Workstation_" + this.workstationType + "_" + this.blockLocation.getBlockX() + "_" + this.blockLocation.getBlockY() + "_" + this.blockLocation.getBlockZ();
        Location center = this.blockLocation.clone().add(0.5, 0.5, 0.5);
        Vector3f pos = item.getPosition();
        Location expectedLoc = center.clone().add((double)pos.x, (double)pos.y, (double)pos.z);
        SchedulerAPI.runTask(expectedLoc, () -> {
            for (Entity nearby : expectedLoc.getWorld().getNearbyEntities(expectedLoc, 0.5, 0.5, 0.5)) {
                ItemDisplay display;
                String displayId;
                if (!(nearby instanceof ItemDisplay) || !locationKey.equals(displayId = PersistentData.getString((PersistentDataHolder)(display = (ItemDisplay)nearby), "workstation_id", ""))) continue;
                nearby.remove();
                return;
            }
        });
    }

    public void removeAllDisplays() {
        if (this.blockLocation.getWorld() == null) {
            return;
        }
        String locationKey = "Workstation_" + this.workstationType + "_" + this.blockLocation.getBlockX() + "_" + this.blockLocation.getBlockY() + "_" + this.blockLocation.getBlockZ();
        Location center = this.blockLocation.clone().add(0.5, 0.5, 0.5);
        for (Entity entity : center.getWorld().getNearbyEntities(center, 2.0, 2.0, 2.0)) {
            ItemDisplay display;
            String displayId;
            if (!(entity instanceof ItemDisplay) || !locationKey.equals(displayId = PersistentData.getString((PersistentDataHolder)(display = (ItemDisplay)entity), "workstation_id", ""))) continue;
            entity.remove();
        }
    }

    public void respawnAllDisplays() {
        if (this.blockLocation.getWorld() == null) {
            return;
        }
        this.removeAllDisplays();
        for (PlacedItem item : this.placedItems) {
            this.spawnItemDisplay(item);
        }
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.workstationType).append(";");
        sb.append(this.placedItems.size());
        for (PlacedItem item : this.placedItems) {
            try {
                String base64 = WorkstationData.itemToBase64(item.getItem());
                sb.append(";").append(base64).append(",").append(item.getPosition().x).append(",").append(item.getPosition().y).append(",").append(item.getPosition().z).append(",").append(item.getYaw());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static WorkstationData deserialize(Location location, String data) {
        String[] parts = data.split(";");
        if (parts.length < 2) {
            return null;
        }
        String type = parts[0];
        WorkstationData workstation = new WorkstationData(location, type);
        try {
            int partIndex;
            int itemCount = Integer.parseInt(parts[1]);
            for (int i = 0; i < itemCount && (partIndex = 2 + i) < parts.length; ++i) {
                String[] itemData = parts[partIndex].split(",");
                String base64 = itemData[0];
                float x = Float.parseFloat(itemData[1]);
                float y = Float.parseFloat(itemData[2]);
                float z = Float.parseFloat(itemData[3]);
                float yaw = Float.parseFloat(itemData[4]);
                ItemStack item = WorkstationData.itemFromBase64(base64);
                Vector3f position = new Vector3f(x, y, z);
                workstation.placedItems.add(new PlacedItem(item, position, yaw));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workstation;
    }

    private static String itemToBase64(ItemStack item) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
        dataOutput.writeObject((Object)item);
        dataOutput.close();
        return Base64.getEncoder().encodeToString(outputStream.toByteArray());
    }

    private static ItemStack itemFromBase64(String base64) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(base64));
        BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
        ItemStack item = (ItemStack)dataInput.readObject();
        dataInput.close();
        return item;
    }

    @Generated
    public Location getBlockLocation() {
        return this.blockLocation;
    }

    @Generated
    public String getWorkstationType() {
        return this.workstationType;
    }

    @Generated
    public List<PlacedItem> getPlacedItems() {
        return this.placedItems;
    }

    public static class PlacedItem {
        private final ItemStack item;
        private final Vector3f position;
        private final float yaw;
        private UUID displayUUID;

        public PlacedItem(ItemStack item, Vector3f position, float yaw) {
            this.item = item;
            this.position = position;
            this.yaw = yaw;
        }

        @Generated
        public ItemStack getItem() {
            return this.item;
        }

        @Generated
        public Vector3f getPosition() {
            return this.position;
        }

        @Generated
        public float getYaw() {
            return this.yaw;
        }

        @Generated
        public void setDisplayUUID(UUID displayUUID) {
            this.displayUUID = displayUUID;
        }

        @Generated
        public UUID getDisplayUUID() {
            return this.displayUUID;
        }
    }
}

