/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.workstations;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;
import org.shotrush.atom.Atom;
import org.shotrush.atom.UtilKt;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;
import org.shotrush.atom.core.util.ActionBarManager;
import org.shotrush.atom.core.workstations.WorkstationData;

public abstract class WorkstationHandler<T extends WorkProgress>
implements Listener {
    protected final Map<UUID, T> activeProcessing = new HashMap<UUID, T>();
    protected final Map<UUID, Boolean> activeDetectionTasks = new HashMap<UUID, Boolean>();
    protected final Atom plugin = Atom.getInstance();

    public abstract boolean isValidTool(ItemStack var1);

    public final boolean handleWrenchInteraction(Player player, ItemStack hand, boolean sneaking, WorkstationData data, Block block) {
        if (!UtilKt.matches(hand, "atom:wrench")) {
            return false;
        }
        if (sneaking) {
            ItemStack removed = data.removeLastItem();
            if (removed != null) {
                player.getInventory().addItem(new ItemStack[]{removed});
            }
            return true;
        }
        return false;
    }

    protected abstract Sound getStrokeSound();

    protected abstract void spawnStrokeParticles(Location var1);

    protected abstract String getStatusMessage();

    public abstract AxisAngle4f getItemRotation();

    public abstract Vector3f getItemScale();

    public abstract boolean handleInteraction(PlayerInteractEvent var1, Block var2, Player var3, ItemStack var4, WorkstationData var5);

    public abstract boolean canPlaceItem(ItemStack var1);

    public abstract Vector3f getPlacementPosition();

    public abstract int getMaxItems();

    public abstract String getFullMessage();

    public abstract String getEmptyMessage();

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ItemStack newItem = player.getInventory().getItem(event.getNewSlot());
        if (newItem == null) {
            return;
        }
        if (this.isValidTool(newItem) && !this.activeDetectionTasks.containsKey(player.getUniqueId())) {
            this.startStrokeDetectionForPlayer(player);
        }
    }

    private void startStrokeDetectionForPlayer(final Player player) {
        this.activeDetectionTasks.put(player.getUniqueId(), true);
        SchedulerAPI.runTask((Entity)player, () -> {
            class StrokeDetectionTask
            implements Runnable {
                StrokeDetectionTask() {
                }

                @Override
                public void run() {
                    long currentTime;
                    ItemStack item;
                    if (!player.isOnline()) {
                        WorkstationHandler.this.activeDetectionTasks.remove(player.getUniqueId());
                        return;
                    }
                    if (!WorkstationHandler.this.isProcessing(player)) {
                        SchedulerAPI.runTaskLater((Entity)player, () -> this.run(), 1L);
                        return;
                    }
                    WorkProgress progress = (WorkProgress)WorkstationHandler.this.activeProcessing.get(player.getUniqueId());
                    if (player.hasActiveItem() && WorkstationHandler.this.isValidTool(item = player.getInventory().getItemInMainHand()) && player.getActiveItemUsedTime() >= 10 && (currentTime = System.currentTimeMillis()) - progress.lastStrokeTime > 300L) {
                        ++progress.currentStrokes;
                        progress.lastStrokeTime = currentTime;
                        player.playSound(player.getLocation(), WorkstationHandler.this.getStrokeSound(), 1.0f, 0.8f + (float)(Math.random() * (double)0.4f));
                        if (progress.location != null) {
                            WorkstationHandler.this.spawnStrokeParticles(progress.location);
                        }
                    }
                    SchedulerAPI.runTaskLater((Entity)player, () -> this.run(), 1L);
                }
            }
            new StrokeDetectionTask().run();
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.activeDetectionTasks.remove(event.getPlayer().getUniqueId());
    }

    public void startProcessing(Player player, Location location, T progress, Runnable onComplete) {
        this.startProcessing(player, location, progress, onComplete, this.getStatusMessage());
    }

    public void startProcessing(final Player player, final Location location, T progress, final Runnable onComplete, String statusMessage) {
        final UUID playerId = player.getUniqueId();
        if (this.activeProcessing.containsKey(playerId)) {
            return;
        }
        this.activeProcessing.put(playerId, progress);
        player.setLevel(0);
        player.setExp(0.0f);
        ActionBarManager.sendStatus(player, statusMessage);
        SchedulerAPI.runTask((Entity)player, () -> {
            class ProcessingTask
            implements Runnable {
                ProcessingTask() {
                }

                @Override
                public void run() {
                    if (!player.isOnline() || !WorkstationHandler.this.activeProcessing.containsKey(playerId)) {
                        WorkstationHandler.this.activeProcessing.remove(playerId);
                        WorkstationHandler.this.onProcessingCancelled(player);
                        return;
                    }
                    WorkProgress currentProgress = (WorkProgress)WorkstationHandler.this.activeProcessing.get(playerId);
                    if (player.getLocation().distance(location) > 5.0) {
                        player.setLevel(0);
                        player.setExp(0.0f);
                        WorkstationHandler.this.activeProcessing.remove(playerId);
                        ActionBarManager.send(player, "\u00a7cYou moved too far away!");
                        WorkstationHandler.this.onProcessingCancelled(player);
                        return;
                    }
                    if (currentProgress.currentStrokes >= currentProgress.requiredStrokes) {
                        player.setLevel(0);
                        player.setExp(0.0f);
                        WorkstationHandler.this.activeProcessing.remove(playerId);
                        onComplete.run();
                        return;
                    }
                    float progressPercent = (float)currentProgress.currentStrokes / (float)currentProgress.requiredStrokes;
                    player.setLevel(currentProgress.currentStrokes);
                    player.setExp(progressPercent);
                    SchedulerAPI.runTaskLater((Entity)player, () -> this.run(), 1L);
                }
            }
            new ProcessingTask().run();
        });
    }

    protected void onProcessingCancelled(Player player) {
    }

    public boolean isProcessing(Player player) {
        return this.activeProcessing.containsKey(player.getUniqueId());
    }

    public T getProgress(Player player) {
        return (T)((WorkProgress)this.activeProcessing.get(player.getUniqueId()));
    }

    public void cancelProcessing(Player player) {
        UUID playerId = player.getUniqueId();
        if (this.activeProcessing.containsKey(playerId)) {
            player.setLevel(0);
            player.setExp(0.0f);
            this.activeProcessing.remove(playerId);
            this.onProcessingCancelled(player);
        }
    }

    public static abstract class WorkProgress {
        public long startTime;
        public int requiredStrokes;
        public int currentStrokes = 0;
        public long lastStrokeTime = 0L;
        public Location location;

        public WorkProgress(long startTime, int requiredStrokes, Location location) {
            this.startTime = startTime;
            this.requiredStrokes = requiredStrokes;
            this.lastStrokeTime = startTime;
            this.location = location != null ? location.clone() : null;
        }
    }
}

