/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.workstations;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import net.momirealms.craftengine.bukkit.api.CraftEngineBlocks;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.core.api.annotation.RegisterSystem;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;
import org.shotrush.atom.core.workstations.WorkstationData;

@RegisterSystem(id="workstation_manager", priority=3, toggleable=false, description="Manages item placement data on CraftEngine workstation blocks")
public class WorkstationManager {
    public static WorkstationManager instance;
    private final Map<Location, WorkstationData> workstations = new HashMap<Location, WorkstationData>();
    private final Plugin plugin;

    public WorkstationManager(Plugin plugin) {
        this.plugin = plugin;
        instance = this;
        this.loadWorkstations();
    }

    private Location toBlockLocation(Block block) {
        return new Location(block.getWorld(), (double)block.getX(), (double)block.getY(), (double)block.getZ());
    }

    public WorkstationData getOrCreate(Block block, String workstationType) {
        Location loc = this.toBlockLocation(block);
        return this.workstations.computeIfAbsent(loc, k -> new WorkstationData((Location)k, workstationType));
    }

    public WorkstationData get(Block block) {
        Location lookupLoc = this.toBlockLocation(block);
        WorkstationData result = this.workstations.get(lookupLoc);
        if (result == null && !this.workstations.isEmpty()) {
            this.plugin.getLogger().info("DEBUG: Looking up " + lookupLoc.getBlockX() + "," + lookupLoc.getBlockY() + "," + lookupLoc.getBlockZ());
            this.plugin.getLogger().info("DEBUG: Map has " + this.workstations.size() + " entries:");
            for (Location loc : this.workstations.keySet()) {
                this.plugin.getLogger().info("  - " + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ() + " (equals: " + loc.equals((Object)lookupLoc) + ")");
            }
        }
        return result;
    }

    public WorkstationData get(Location location) {
        return this.workstations.get(location);
    }

    public int getWorkstationCount() {
        return this.workstations.size();
    }

    public void remove(Block block) {
        WorkstationData data = this.workstations.remove(this.toBlockLocation(block));
        if (data != null) {
            data.clearAllItems();
        }
    }

    public boolean isWorkstationBlock(Block block, String workstationType) {
        Key key = Key.of((String)("atom:" + workstationType));
        return CraftEngineBlocks.getCustomBlockState((Block)block) != null && Objects.requireNonNull(CraftEngineBlocks.getCustomBlockState((Block)block)).owner().matchesKey(key);
    }

    public void saveWorkstations() {
        File file = new File(this.plugin.getDataFolder(), "workstations.dat");
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(file));){
            out.writeInt(this.workstations.size());
            for (Map.Entry<Location, WorkstationData> entry : this.workstations.entrySet()) {
                Location loc = entry.getKey();
                WorkstationData data = entry.getValue();
                this.plugin.getLogger().info("Saving workstation at " + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ() + " with " + data.getPlacedItems().size() + " items");
                out.writeUTF(loc.getWorld().getName());
                out.writeInt(loc.getBlockX());
                out.writeInt(loc.getBlockY());
                out.writeInt(loc.getBlockZ());
                String serialized = data.serialize();
                this.plugin.getLogger().info("Serialized data: " + serialized);
                out.writeUTF(serialized);
            }
            this.plugin.getLogger().info("Saved " + this.workstations.size() + " workstation(s)");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save workstations: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void loadWorkstations() {
        File file = new File(this.plugin.getDataFolder(), "workstations.dat");
        if (!file.exists()) {
            this.plugin.getLogger().info("No workstations data file found");
            return;
        }
        try (DataInputStream in = new DataInputStream(new FileInputStream(file));){
            int count2 = in.readInt();
            this.plugin.getLogger().info("Loading " + count2 + " workstation(s)");
            for (int i = 0; i < count2; ++i) {
                String worldName = in.readUTF();
                int x = in.readInt();
                int y = in.readInt();
                int z = in.readInt();
                World world = this.plugin.getServer().getWorld(worldName);
                if (world == null) {
                    this.plugin.getLogger().warning("World " + worldName + " not found, skipping workstation");
                    continue;
                }
                Location loc = new Location(world, (double)x, (double)y, (double)z);
                String data = in.readUTF();
                this.plugin.getLogger().info("Loading workstation at " + x + "," + y + "," + z + " - data: " + data);
                WorkstationData workstation = WorkstationData.deserialize(loc, data);
                if (workstation != null) {
                    this.plugin.getLogger().info("Deserialized workstation with " + workstation.getPlacedItems().size() + " items");
                    this.workstations.put(loc, workstation);
                    continue;
                }
                this.plugin.getLogger().warning("Failed to deserialize workstation data");
            }
            this.plugin.getLogger().info("Loaded " + this.workstations.size() + " workstation(s)");
            for (WorkstationData data : this.workstations.values()) {
                SchedulerAPI.runTaskLater(data.getBlockLocation(), () -> {
                    data.respawnAllDisplays();
                    this.plugin.getLogger().info("Respawned displays for workstation at " + data.getBlockLocation().getBlockX() + "," + data.getBlockLocation().getBlockY() + "," + data.getBlockLocation().getBlockZ());
                }, 40L);
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to load workstations: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Generated
    public static WorkstationManager getInstance() {
        return instance;
    }
}

