/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.item;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.DyedItemColor;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import io.papermc.paper.persistence.PersistentDataContainerView;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.momirealms.craftengine.bukkit.api.CraftEngineItems;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.Color;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.shotrush.atom.UtilKt;
import org.shotrush.atom.item.Material;
import org.shotrush.atom.item.MoldShape;
import org.shotrush.atom.item.MoldType;
import org.shotrush.atom.item.MoldsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0006J\u000e\u0010!\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0006J\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060#2\u0006\u0010\u001d\u001a\u00020\u0006R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0019\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014\u00a8\u0006$"}, d2={"Lorg/shotrush/atom/item/Molds;", "", "<init>", "()V", "getMold", "Lnet/momirealms/craftengine/core/item/CustomItem;", "Lorg/bukkit/inventory/ItemStack;", "tool", "Lorg/shotrush/atom/item/MoldShape;", "variant", "Lorg/shotrush/atom/item/MoldType;", "getToolHead", "material", "Lorg/shotrush/atom/item/Material;", "getIngot", "getFilledMold", "shape", "FilledRegex", "Lkotlin/text/Regex;", "getFilledRegex", "()Lkotlin/text/Regex;", "EmptyRegex", "getEmptyRegex", "UnfiredRegex", "getUnfiredRegex", "FullRegex", "getFullRegex", "isFilledMold", "", "stack", "isEmptyMold", "isMold", "getMoldType", "getMoldShape", "emptyMold", "Lkotlin/Pair;", "Atom"})
public final class Molds {
    @NotNull
    public static final Molds INSTANCE = new Molds();
    @NotNull
    private static final Regex FilledRegex = new Regex("atom:filled_(.+)_mold_(.+)");
    @NotNull
    private static final Regex EmptyRegex = new Regex("atom:(fired|wax)_mold_(.+)");
    @NotNull
    private static final Regex UnfiredRegex = new Regex("atom:clay_mold_(.+)");
    @NotNull
    private static final Regex FullRegex = new Regex("atom:(\\w+)_mold_(.+)");

    private Molds() {
    }

    @NotNull
    public final CustomItem<ItemStack> getMold(@NotNull MoldShape tool, @NotNull MoldType variant) {
        Intrinsics.checkNotNullParameter((Object)tool, "tool");
        Intrinsics.checkNotNullParameter((Object)variant, "variant");
        CustomItem customItem = CraftEngineItems.byId((Key)Key.of((String)"atom", (String)(variant.getId() + "_mold_" + tool.getMold())));
        Intrinsics.checkNotNull(customItem);
        return customItem;
    }

    @NotNull
    public final CustomItem<ItemStack> getToolHead(@NotNull MoldShape tool, @NotNull Material material) {
        Intrinsics.checkNotNullParameter((Object)tool, "tool");
        Intrinsics.checkNotNullParameter((Object)material, "material");
        String key = material.getId() + "_" + tool.getId() + "_head";
        CustomItem customItem = CraftEngineItems.byId((Key)Key.of((String)"atom", (String)key));
        if (customItem == null) {
            throw new IllegalStateException(("No tool head found for " + key).toString());
        }
        return customItem;
    }

    @NotNull
    public final ItemStack getIngot(@NotNull Material material) {
        Intrinsics.checkNotNullParameter((Object)material, "material");
        if (material == Material.Iron) {
            return new ItemStack(org.bukkit.Material.IRON_INGOT);
        }
        if (material == Material.Copper) {
            return new ItemStack(org.bukkit.Material.COPPER_INGOT);
        }
        CustomItem customItem = CraftEngineItems.byId((Key)Key.of((String)"atom", (String)("ingot_" + material.getId())));
        Intrinsics.checkNotNull(customItem);
        Object object = customItem.buildItemStack();
        Intrinsics.checkNotNullExpressionValue(object, "buildItemStack(...)");
        return (ItemStack)object;
    }

    @NotNull
    public final ItemStack getFilledMold(@NotNull MoldShape shape, @NotNull MoldType variant, @NotNull Material material) {
        Intrinsics.checkNotNullParameter((Object)shape, "shape");
        Intrinsics.checkNotNullParameter((Object)variant, "variant");
        Intrinsics.checkNotNullParameter((Object)material, "material");
        if (variant != MoldType.Wax && variant != MoldType.Fired) {
            throw new IllegalArgumentException("Only Wax and Fired molds can be filled!");
        }
        CustomItem customItem = CraftEngineItems.byId((Key)Key.of((String)"atom", (String)("filled_" + variant.getId() + "_mold_" + shape.getMold())));
        Intrinsics.checkNotNull(customItem);
        CustomItem item = customItem;
        ItemStack stack = (ItemStack)item.buildItemStack();
        stack.setData(DataComponentTypes.DYED_COLOR, (Object)DyedItemColor.dyedItemColor((Color)material.getRgb()));
        stack.setData(DataComponentTypes.TOOLTIP_DISPLAY, TooltipDisplay.tooltipDisplay().hiddenComponents(SetsKt.setOf(DataComponentTypes.DYED_COLOR)).build());
        stack.editPersistentDataContainer(arg_0 -> Molds.getFilledMold$lambda$0(variant, shape, material, arg_0));
        Intrinsics.checkNotNull(stack);
        return stack;
    }

    @NotNull
    public final Regex getFilledRegex() {
        return FilledRegex;
    }

    @NotNull
    public final Regex getEmptyRegex() {
        return EmptyRegex;
    }

    @NotNull
    public final Regex getUnfiredRegex() {
        return UnfiredRegex;
    }

    @NotNull
    public final Regex getFullRegex() {
        return FullRegex;
    }

    public final boolean isFilledMold(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        CharSequence charSequence = UtilKt.getNamespacedKey(stack);
        if (!FilledRegex.matches(charSequence)) {
            return false;
        }
        PersistentDataContainerView persistentDataContainerView = stack.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainerView, "getPersistentDataContainer(...)");
        if (!MoldsKt.has(persistentDataContainerView, "mold_type")) {
            return false;
        }
        PersistentDataContainerView persistentDataContainerView2 = stack.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainerView2, "getPersistentDataContainer(...)");
        if (!MoldsKt.has(persistentDataContainerView2, "mold_shape")) {
            return false;
        }
        PersistentDataContainerView persistentDataContainerView3 = stack.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainerView3, "getPersistentDataContainer(...)");
        return MoldsKt.has(persistentDataContainerView3, "mold_fill");
    }

    public final boolean isEmptyMold(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        CharSequence charSequence = UtilKt.getNamespacedKey(stack);
        return EmptyRegex.matches(charSequence);
    }

    public final boolean isMold(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        CharSequence charSequence = UtilKt.getNamespacedKey(stack);
        return FullRegex.matches(charSequence);
    }

    @NotNull
    public final MoldType getMoldType(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        String key = UtilKt.getNamespacedKey(stack);
        if (StringsKt.startsWith$default(key, "atom:wax_", false, 2, null)) {
            return MoldType.Wax;
        }
        if (StringsKt.startsWith$default(key, "atom:fired_", false, 2, null)) {
            return MoldType.Fired;
        }
        if (StringsKt.startsWith$default(key, "atom:clay_", false, 2, null)) {
            return MoldType.Clay;
        }
        if (StringsKt.startsWith$default(key, "atom:filled_", false, 2, null)) {
            PersistentDataContainerView persistentDataContainerView = stack.getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(persistentDataContainerView, "getPersistentDataContainer(...)");
            String string = MoldsKt.getString(persistentDataContainerView, "mold_type");
            if (string == null) {
                throw new IllegalStateException("No mold type found!".toString());
            }
            String moldTypeId = string;
            MoldType moldType = MoldType.Companion.byId(moldTypeId);
            return moldType;
        }
        throw new IllegalArgumentException("Item is not a mold!");
    }

    @NotNull
    public final MoldShape getMoldShape(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        String key = UtilKt.getNamespacedKey(stack);
        CharSequence charSequence = key;
        if (FullRegex.matches(charSequence)) {
            MatchResult matchResult = Regex.find$default(FullRegex, key, 0, 2, null);
            Intrinsics.checkNotNull(matchResult);
            MatchResult regex = matchResult;
            String moldShapeId = regex.getGroupValues().get(2);
            return MoldShape.Companion.byMold(moldShapeId);
        }
        throw new IllegalStateException("Item is not a mold!".toString());
    }

    @NotNull
    public final Pair<ItemStack, ItemStack> emptyMold(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        if (!this.isFilledMold(stack)) {
            throw new IllegalArgumentException("Item is not a filled mold!");
        }
        PersistentDataContainerView persistentDataContainerView = stack.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainerView, "getPersistentDataContainer(...)");
        String string = MoldsKt.getString(persistentDataContainerView, "mold_type");
        if (string == null) {
            throw new IllegalStateException("No mold type found!".toString());
        }
        String moldTypeId = string;
        PersistentDataContainerView persistentDataContainerView2 = stack.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainerView2, "getPersistentDataContainer(...)");
        String string2 = MoldsKt.getString(persistentDataContainerView2, "mold_shape");
        if (string2 == null) {
            throw new IllegalStateException("No mold shape found!".toString());
        }
        String moldShapeId = string2;
        PersistentDataContainerView persistentDataContainerView3 = stack.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainerView3, "getPersistentDataContainer(...)");
        String string3 = MoldsKt.getString(persistentDataContainerView3, "mold_fill");
        if (string3 == null) {
            throw new IllegalStateException("No material found!".toString());
        }
        String materialId = string3;
        MoldType moldType = MoldType.Companion.byId(moldTypeId);
        MoldShape moldShape = MoldShape.Companion.byId(moldShapeId);
        Material material = Material.Companion.byId(materialId);
        ItemStack emptyMold = moldType == MoldType.Wax ? ItemStack.empty() : (ItemStack)this.getMold(moldShape, moldType).buildItemStack();
        ItemStack toolHead = moldShape == MoldShape.Ingot ? this.getIngot(material) : (ItemStack)this.getToolHead(moldShape, material).buildItemStack();
        return new Pair<ItemStack, ItemStack>(emptyMold, toolHead);
    }

    private static final void getFilledMold$lambda$0(MoldType $variant, MoldShape $shape, Material $material, PersistentDataContainer it) {
        it.set(new NamespacedKey("atom", "mold_type"), PersistentDataType.STRING, (Object)$variant.getId());
        it.set(new NamespacedKey("atom", "mold_shape"), PersistentDataType.STRING, (Object)$shape.getId());
        it.set(new NamespacedKey("atom", "mold_fill"), PersistentDataType.STRING, (Object)$material.getId());
    }
}

