/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.listener;

import com.github.shynixn.mccoroutine.folia.MCCoroutineKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shotrush.atom.Atom;
import org.shotrush.atom.UtilKt;
import org.shotrush.atom.core.util.ActionBarManager;
import org.shotrush.atom.item.Material;
import org.shotrush.atom.item.MoldShape;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u001e\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u001e\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0087@\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001cH\u0087@\u00a2\u0006\u0002\u0010\u001dJJ\u0010\u001e\u001a\u00020\u0005*\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u000f2\b\b\u0002\u0010!\u001a\u00020\u000f2\b\b\u0002\u0010\"\u001a\u00020\u000f2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\nH\u0002R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/shotrush/atom/listener/PlayerMiningListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "register", "", "atom", "Lorg/shotrush/atom/Atom;", "miningRequirements", "", "", "Lkotlin/Pair;", "Lorg/shotrush/atom/item/MoldShape;", "Lorg/shotrush/atom/item/Material;", "isRelevantBlock", "", "blockKey", "requiredFor", "isTierAtLeast", "actual", "required", "parseTool", "stack", "Lorg/bukkit/inventory/ItemStack;", "on", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "(Lorg/bukkit/event/player/PlayerInteractEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lorg/bukkit/event/block/BlockBreakEvent;", "(Lorg/bukkit/event/block/BlockBreakEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "feedback", "Lorg/bukkit/entity/Player;", "needTool", "wrongShape", "tooLowTier", "requiredTier", "shape", "Atom"})
@SourceDebugExtension(value={"SMAP\nPlayerMiningListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerMiningListener.kt\norg/shotrush/atom/listener/PlayerMiningListener\n+ 2 ListenerUtil.kt\norg/shotrush/atom/listener/ListenerUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n7#2:251\n7#2:252\n295#3,2:253\n295#3,2:255\n1#4:257\n*S KotlinDebug\n*F\n+ 1 PlayerMiningListener.kt\norg/shotrush/atom/listener/PlayerMiningListener\n*L\n26#1:251\n27#1:252\n152#1:253,2\n153#1:255,2\n*E\n"})
public final class PlayerMiningListener
implements Listener {
    @NotNull
    public static final PlayerMiningListener INSTANCE;
    @NotNull
    private static final Map<String, Pair<MoldShape, Material>> miningRequirements;

    private PlayerMiningListener() {
    }

    public final void register(@NotNull Atom atom) {
        Intrinsics.checkNotNullParameter(atom, "atom");
        Pair[] pairArray = new Pair[2];
        Function1<BlockBreakEvent, CoroutineContext> runner$iv = arg_0 -> PlayerMiningListener.register$lambda$0(atom, arg_0);
        boolean $i$f$eventDef = false;
        Intrinsics.checkNotNull(TuplesKt.to(BlockBreakEvent.class, runner$iv), "null cannot be cast to non-null type kotlin.Pair<java.lang.Class<out org.bukkit.event.Event>, kotlin.Function1<@[ParameterName(name = \"event\")] org.bukkit.event.Event, kotlin.coroutines.CoroutineContext>>");
        runner$iv = arg_0 -> PlayerMiningListener.register$lambda$1(atom, arg_0);
        $i$f$eventDef = false;
        Intrinsics.checkNotNull(TuplesKt.to(PlayerInteractEvent.class, runner$iv), "null cannot be cast to non-null type kotlin.Pair<java.lang.Class<out org.bukkit.event.Event>, kotlin.Function1<@[ParameterName(name = \"event\")] org.bukkit.event.Event, kotlin.coroutines.CoroutineContext>>");
        Map eventDispatcher = MapsKt.mapOf(pairArray);
        PluginManager pluginManager = atom.getServer().getPluginManager();
        Intrinsics.checkNotNullExpressionValue(pluginManager, "getPluginManager(...)");
        MCCoroutineKt.registerSuspendingEvents(pluginManager, this, atom, eventDispatcher);
    }

    private final boolean isRelevantBlock(String blockKey) {
        return miningRequirements.containsKey(blockKey);
    }

    private final Pair<MoldShape, Material> requiredFor(String blockKey) {
        return miningRequirements.get(blockKey);
    }

    private final boolean isTierAtLeast(Material actual, Material required) {
        return actual.ordinal() >= required.ordinal();
    }

    private final Pair<Material, MoldShape> parseTool(ItemStack stack) {
        Object v2;
        MoldShape shape;
        block5: {
            Object v0;
            String path;
            block4: {
                path = UtilKt.getNamespacedPath(stack);
                Iterable $this$firstOrNull$iv = MoldShape.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MoldShape it = (MoldShape)((Object)element$iv);
                    boolean bl = false;
                    if (!StringsKt.endsWith$default(path, "_" + it.getId(), false, 2, null)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            MoldShape moldShape = v0;
            if (moldShape == null) {
                return null;
            }
            shape = moldShape;
            Iterable $this$firstOrNull$iv = Material.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Material it = (Material)((Object)element$iv);
                boolean bl = false;
                if (!StringsKt.startsWith$default(path, it.getId() + "_", false, 2, null)) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        Material material = v2;
        if (material == null) {
            return null;
        }
        Material tier = material;
        return TuplesKt.to(tier, shape);
    }

    @EventHandler
    @Nullable
    public final Object on(@NotNull PlayerInteractEvent event, @NotNull Continuation<? super Unit> $completion) {
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return Unit.INSTANCE;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (player2.getGameMode() == GameMode.CREATIVE) {
            return Unit.INSTANCE;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return Unit.INSTANCE;
        }
        Block block2 = block;
        String blockKey = UtilKt.getNamespacedKey(block2);
        if (!this.isRelevantBlock(blockKey)) {
            return Unit.INSTANCE;
        }
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            ItemStack itemStack2 = ItemStack.empty();
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue(itemStack2, "empty(...)");
        }
        ItemStack item = itemStack;
        Pair<Material, MoldShape> tool = this.parseTool(item);
        Pair<MoldShape, Material> pair = this.requiredFor(blockKey);
        if (pair == null) {
            return Unit.INSTANCE;
        }
        Pair<MoldShape, Material> pair2 = pair;
        MoldShape requiredShape = pair2.component1();
        Material requiredTier = pair2.component2();
        if (tool == null) {
            PlayerMiningListener.feedback$default(this, player2, true, false, false, null, null, blockKey, 30, null);
            return Unit.INSTANCE;
        }
        Pair<Material, MoldShape> pair3 = tool;
        Material tier = pair3.component1();
        MoldShape shape = pair3.component2();
        if (shape != requiredShape) {
            PlayerMiningListener.feedback$default(this, player2, false, true, false, null, shape, blockKey, 13, null);
            return Unit.INSTANCE;
        }
        if (!this.isTierAtLeast(tier, requiredTier)) {
            PlayerMiningListener.feedback$default(this, player2, false, false, true, requiredTier, requiredShape, blockKey, 3, null);
        }
        return Unit.INSTANCE;
    }

    @EventHandler
    @Nullable
    public final Object on(@NotNull BlockBreakEvent event, @NotNull Continuation<? super Unit> $completion) {
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (player2.getGameMode() == GameMode.CREATIVE) {
            return Unit.INSTANCE;
        }
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        String blockKey = UtilKt.getNamespacedKey(block2);
        if (!this.isRelevantBlock(blockKey)) {
            return Unit.INSTANCE;
        }
        ItemStack itemStack = player2.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInMainHand(...)");
        ItemStack item = itemStack;
        Pair<Material, MoldShape> tool = this.parseTool(item);
        Pair<MoldShape, Material> pair = this.requiredFor(blockKey);
        if (pair == null) {
            return Unit.INSTANCE;
        }
        Pair<MoldShape, Material> pair2 = pair;
        MoldShape requiredShape = pair2.component1();
        Material requiredTier = pair2.component2();
        if (tool == null) {
            event.setCancelled(true);
            PlayerMiningListener.feedback$default(this, player2, true, false, false, null, null, blockKey, 30, null);
            return Unit.INSTANCE;
        }
        Pair<Material, MoldShape> pair3 = tool;
        Material tier = pair3.component1();
        MoldShape shape = pair3.component2();
        if (shape != requiredShape) {
            event.setCancelled(true);
            PlayerMiningListener.feedback$default(this, player2, false, true, false, null, shape, blockKey, 13, null);
            return Unit.INSTANCE;
        }
        if (!this.isTierAtLeast(tier, requiredTier)) {
            event.setCancelled(true);
            PlayerMiningListener.feedback$default(this, player2, false, false, true, requiredTier, requiredShape, blockKey, 3, null);
        }
        return Unit.INSTANCE;
    }

    private final void feedback(Player $this$feedback, boolean needTool, boolean wrongShape, boolean tooLowTier, Material requiredTier, MoldShape shape, String blockKey) {
        String msg;
        String string;
        block8: {
            block9: {
                Object object;
                block11: {
                    block10: {
                        block7: {
                            if (!needTool) break block7;
                            string = "You need a proper tool to mine " + blockKey + ".";
                            break block8;
                        }
                        if (!wrongShape) break block9;
                        object = shape;
                        if (object == null) break block10;
                        MoldShape it = object;
                        boolean bl = false;
                        String string2 = " (" + it + ")";
                        object = string2;
                        if (string2 != null) break block11;
                    }
                    object = "";
                }
                string = "Wrong tool type" + (String)object + " for " + blockKey + ".";
                break block8;
            }
            if (tooLowTier) {
                Material material = requiredTier;
                string = "Your tool is too weak. Need <l10n:material." + (material != null ? material.getId() : null) + ".name> or better.";
            } else {
                string = null;
            }
        }
        String string3 = msg = string;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            ActionBarManager.send($this$feedback, "mining", it, 4);
        }
        $this$feedback.playSound($this$feedback.getLocation(), Sound.BLOCK_ANVIL_PLACE, 0.7f, 1.7f);
    }

    static /* synthetic */ void feedback$default(PlayerMiningListener playerMiningListener, Player player, boolean bl, boolean bl2, boolean bl3, Material material, MoldShape moldShape, String string, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            material = null;
        }
        if ((n & 0x10) != 0) {
            moldShape = null;
        }
        playerMiningListener.feedback(player, bl, bl2, bl3, material, moldShape, string);
    }

    private static final CoroutineContext register$lambda$0(Atom $atom, BlockBreakEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Plugin plugin = $atom;
        Location location = it.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        return MCCoroutineKt.regionDispatcher(plugin, location);
    }

    private static final CoroutineContext register$lambda$1(Atom $atom, PlayerInteractEvent it) {
        CoroutineContext coroutineContext;
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.getClickedBlock() != null) {
            Plugin plugin = $atom;
            Block block = it.getClickedBlock();
            Intrinsics.checkNotNull(block);
            Location location = block.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            coroutineContext = MCCoroutineKt.regionDispatcher(plugin, location);
        } else {
            Plugin plugin = $atom;
            Player player = it.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            coroutineContext = MCCoroutineKt.entityDispatcher(plugin, (Entity)player);
        }
        return coroutineContext;
    }

    static {
        Map<String, Pair<MoldShape, Material>> map2;
        INSTANCE = new PlayerMiningListener();
        Map<String, Pair<MoldShape, Material>> $this$miningRequirements_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$miningRequirements_u24lambda_u240.put("minecraft:dirt", TuplesKt.to(MoldShape.Shovel, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:grass_block", TuplesKt.to(MoldShape.Shovel, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:mud", TuplesKt.to(MoldShape.Shovel, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:podzol", TuplesKt.to(MoldShape.Shovel, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:coarse_dirt", TuplesKt.to(MoldShape.Shovel, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:rooted_dirt", TuplesKt.to(MoldShape.Shovel, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:stone", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:cobblestone", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:andesite", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:diorite", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:granite", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:tuff", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:calcite", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:dripstone_block", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:packed_mud", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:deepslate", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:cobbled_deepslate", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:polished_deepslate", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:deepslate_bricks", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:deepslate_tiles", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:coal_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:copper_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("atom:tin_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Copper));
        $this$miningRequirements_u24lambda_u240.put("minecraft:iron_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Bronze));
        $this$miningRequirements_u24lambda_u240.put("minecraft:gold_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Iron));
        $this$miningRequirements_u24lambda_u240.put("minecraft:redstone_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Iron));
        $this$miningRequirements_u24lambda_u240.put("minecraft:lapis_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Copper));
        $this$miningRequirements_u24lambda_u240.put("minecraft:diamond_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:emerald_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:deepslate_coal_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:deepslate_copper_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:deepslate_iron_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:deepslate_gold_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:deepslate_redstone_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:deepslate_lapis_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:deepslate_diamond_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:deepslate_emerald_ore", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:raw_iron_block", TuplesKt.to(MoldShape.Pickaxe, Material.Copper));
        $this$miningRequirements_u24lambda_u240.put("minecraft:raw_copper_block", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:raw_gold_block", TuplesKt.to(MoldShape.Pickaxe, Material.Iron));
        $this$miningRequirements_u24lambda_u240.put("minecraft:iron_block", TuplesKt.to(MoldShape.Pickaxe, Material.Copper));
        $this$miningRequirements_u24lambda_u240.put("minecraft:copper_block", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:gold_block", TuplesKt.to(MoldShape.Pickaxe, Material.Iron));
        $this$miningRequirements_u24lambda_u240.put("minecraft:lapis_block", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:diamond_block", TuplesKt.to(MoldShape.Pickaxe, Material.Iron));
        $this$miningRequirements_u24lambda_u240.put("minecraft:emerald_block", TuplesKt.to(MoldShape.Pickaxe, Material.Iron));
        $this$miningRequirements_u24lambda_u240.put("minecraft:redstone_block", TuplesKt.to(MoldShape.Pickaxe, Material.Iron));
        $this$miningRequirements_u24lambda_u240.put("minecraft:netherite_block", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:obsidian", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:crying_obsidian", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:ancient_debris", TuplesKt.to(MoldShape.Pickaxe, Material.Steel));
        $this$miningRequirements_u24lambda_u240.put("minecraft:stone_bricks", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:mossy_stone_bricks", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:smooth_stone", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:cobblestone_wall", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:cobblestone_stairs", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:cobblestone_slab", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:white_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:orange_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:magenta_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:light_blue_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:yellow_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:lime_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:pink_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:gray_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:light_gray_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:cyan_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:purple_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:blue_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:brown_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:green_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:red_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:black_glazed_terracotta", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:bricks", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:prismarine", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:packed_ice", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        $this$miningRequirements_u24lambda_u240.put("minecraft:blue_ice", TuplesKt.to(MoldShape.Pickaxe, Material.Stone));
        miningRequirements = MapsKt.build(map2);
    }
}

