/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.listener;

import com.github.shynixn.mccoroutine.folia.MCCoroutineKt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.shotrush.atom.Atom;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001eH\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/shotrush/atom/listener/RecipeUnlockHandler;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "recipeIngredients", "", "Lorg/bukkit/NamespacedKey;", "", "Lorg/bukkit/inventory/RecipeChoice;", "REQUIRE_ALL", "", "register", "", "atom", "Lorg/shotrush/atom/Atom;", "extractRecipeIngredients", "onPickupItem", "event", "Lorg/bukkit/event/entity/EntityPickupItemEvent;", "onInventoryClick", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "onInventoryClose", "Lorg/bukkit/event/inventory/InventoryCloseEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "checkAndUnlockRecipes", "player", "Lorg/bukkit/entity/Player;", "hasRequiredIngredients", "requiredIngredients", "", "Atom"})
@SourceDebugExtension(value={"SMAP\nRecipeUnlockHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecipeUnlockHandler.kt\norg/shotrush/atom/listener/RecipeUnlockHandler\n+ 2 ListenerUtil.kt\norg/shotrush/atom/listener/ListenerUtilKt\n*L\n1#1,127:1\n7#2:128\n7#2:129\n7#2:130\n7#2:131\n*S KotlinDebug\n*F\n+ 1 RecipeUnlockHandler.kt\norg/shotrush/atom/listener/RecipeUnlockHandler\n*L\n36#1:128\n37#1:129\n38#1:130\n39#1:131\n*E\n"})
public final class RecipeUnlockHandler
implements Listener {
    @NotNull
    public static final RecipeUnlockHandler INSTANCE = new RecipeUnlockHandler();
    @NotNull
    private static final Map<NamespacedKey, List<RecipeChoice>> recipeIngredients = new HashMap();
    private static final boolean REQUIRE_ALL = false;

    private RecipeUnlockHandler() {
    }

    public final void register(@NotNull Atom atom) {
        Intrinsics.checkNotNullParameter(atom, "atom");
        Pair[] pairArray = new Pair[4];
        Function1<EntityPickupItemEvent, CoroutineContext> runner$iv = arg_0 -> RecipeUnlockHandler.register$lambda$0(atom, arg_0);
        boolean $i$f$eventDef = false;
        Intrinsics.checkNotNull(TuplesKt.to(EntityPickupItemEvent.class, runner$iv), "null cannot be cast to non-null type kotlin.Pair<java.lang.Class<out org.bukkit.event.Event>, kotlin.Function1<@[ParameterName(name = \"event\")] org.bukkit.event.Event, kotlin.coroutines.CoroutineContext>>");
        runner$iv = arg_0 -> RecipeUnlockHandler.register$lambda$1(atom, arg_0);
        $i$f$eventDef = false;
        Intrinsics.checkNotNull(TuplesKt.to(InventoryClickEvent.class, runner$iv), "null cannot be cast to non-null type kotlin.Pair<java.lang.Class<out org.bukkit.event.Event>, kotlin.Function1<@[ParameterName(name = \"event\")] org.bukkit.event.Event, kotlin.coroutines.CoroutineContext>>");
        runner$iv = arg_0 -> RecipeUnlockHandler.register$lambda$2(atom, arg_0);
        $i$f$eventDef = false;
        Intrinsics.checkNotNull(TuplesKt.to(InventoryCloseEvent.class, runner$iv), "null cannot be cast to non-null type kotlin.Pair<java.lang.Class<out org.bukkit.event.Event>, kotlin.Function1<@[ParameterName(name = \"event\")] org.bukkit.event.Event, kotlin.coroutines.CoroutineContext>>");
        runner$iv = arg_0 -> RecipeUnlockHandler.register$lambda$3(atom, arg_0);
        $i$f$eventDef = false;
        Intrinsics.checkNotNull(TuplesKt.to(PlayerJoinEvent.class, runner$iv), "null cannot be cast to non-null type kotlin.Pair<java.lang.Class<out org.bukkit.event.Event>, kotlin.Function1<@[ParameterName(name = \"event\")] org.bukkit.event.Event, kotlin.coroutines.CoroutineContext>>");
        Map eventDispatcher = MapsKt.mapOf(pairArray);
        PluginManager pluginManager = atom.getServer().getPluginManager();
        Intrinsics.checkNotNullExpressionValue(pluginManager, "getPluginManager(...)");
        MCCoroutineKt.registerSuspendingEvents(pluginManager, this, atom, eventDispatcher);
    }

    private final void extractRecipeIngredients() {
        Iterator iterator2 = Bukkit.recipeIterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "recipeIterator(...)");
        Iterator recipeIterator = iterator2;
        while (recipeIterator.hasNext()) {
            NamespacedKey key;
            Recipe recipe = (Recipe)recipeIterator.next();
            if (!(recipe instanceof Keyed)) continue;
            Intrinsics.checkNotNullExpressionValue(((Keyed)recipe).getKey(), "getKey(...)");
            if (!Intrinsics.areEqual(key.getNamespace(), "atom")) continue;
            List ingredients = new ArrayList();
            if (recipe instanceof ShapedRecipe) {
                Map choiceMap;
                Intrinsics.checkNotNullExpressionValue(((ShapedRecipe)recipe).getChoiceMap(), "getChoiceMap(...)");
                ingredients.addAll(choiceMap.values());
            } else if (recipe instanceof ShapelessRecipe) {
                List list = ((ShapelessRecipe)recipe).getChoiceList();
                Intrinsics.checkNotNullExpressionValue(list, "getChoiceList(...)");
                ingredients.addAll(list);
            }
            if (ingredients.isEmpty()) continue;
            recipeIngredients.put(key, ingredients);
            Atom.Companion.getInstance().getLogger().info("Extracted " + ingredients.size() + " ingredients from recipe: " + key.getKey());
        }
    }

    @EventHandler
    public final void onPickupItem(@NotNull EntityPickupItemEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getEntity() instanceof Player) {
            LivingEntity livingEntity = event.getEntity();
            Intrinsics.checkNotNull(livingEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
            this.checkAndUnlockRecipes((Player)livingEntity);
        }
    }

    @EventHandler
    public final void onInventoryClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getWhoClicked() instanceof Player) {
            HumanEntity humanEntity = event.getWhoClicked();
            Intrinsics.checkNotNull(humanEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
            this.checkAndUnlockRecipes((Player)humanEntity);
        }
    }

    @EventHandler
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getPlayer() instanceof Player) {
            HumanEntity humanEntity = event.getPlayer();
            Intrinsics.checkNotNull(humanEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
            this.checkAndUnlockRecipes((Player)humanEntity);
        }
    }

    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        this.checkAndUnlockRecipes(player2);
    }

    private final void checkAndUnlockRecipes(Player player) {
        for (Map.Entry<NamespacedKey, List<RecipeChoice>> entry : recipeIngredients.entrySet()) {
            NamespacedKey key = entry.getKey();
            List<RecipeChoice> ingredients = entry.getValue();
            if (player.hasDiscoveredRecipe(key) || !this.hasRequiredIngredients(player, ingredients)) continue;
            player.discoverRecipe(key);
            player.sendMessage("\u00a7a\u00a7l\u2713 \u00a7aYou discovered a new recipe!");
        }
    }

    private final boolean hasRequiredIngredients(Player player, List<? extends RecipeChoice> requiredIngredients) {
        ItemStack[] itemStackArray = player.getInventory().getContents();
        Intrinsics.checkNotNullExpressionValue(itemStackArray, "getContents(...)");
        ItemStack[] contents = itemStackArray;
        Iterator<? extends RecipeChoice> iterator2 = requiredIngredients.iterator();
        if (iterator2.hasNext()) {
            RecipeChoice choice = iterator2.next();
            boolean found = false;
            int n = contents.length;
            for (int i = 0; i < n; ++i) {
                ItemStack item;
                ItemStack itemStack = item = contents[i];
                boolean bl = itemStack != null ? !itemStack.isEmpty() : false;
                if (!bl || !choice.test(item)) continue;
                found = true;
                return true;
            }
            return false;
        }
        return true;
    }

    private static final CoroutineContext register$lambda$0(Atom $atom, EntityPickupItemEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Plugin plugin = $atom;
        LivingEntity livingEntity = it.getEntity();
        Intrinsics.checkNotNullExpressionValue(livingEntity, "getEntity(...)");
        return MCCoroutineKt.entityDispatcher(plugin, (Entity)livingEntity);
    }

    private static final CoroutineContext register$lambda$1(Atom $atom, InventoryClickEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Plugin plugin = $atom;
        HumanEntity humanEntity = it.getWhoClicked();
        Intrinsics.checkNotNullExpressionValue(humanEntity, "getWhoClicked(...)");
        return MCCoroutineKt.entityDispatcher(plugin, (Entity)humanEntity);
    }

    private static final CoroutineContext register$lambda$2(Atom $atom, InventoryCloseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Plugin plugin = $atom;
        HumanEntity humanEntity = it.getPlayer();
        Intrinsics.checkNotNullExpressionValue(humanEntity, "getPlayer(...)");
        return MCCoroutineKt.entityDispatcher(plugin, (Entity)humanEntity);
    }

    private static final CoroutineContext register$lambda$3(Atom $atom, PlayerJoinEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Plugin plugin = $atom;
        Player player = it.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        return MCCoroutineKt.entityDispatcher(plugin, (Entity)player);
    }

    public static final /* synthetic */ void access$extractRecipeIngredients(RecipeUnlockHandler $this) {
        $this.extractRecipeIngredients();
    }

    static {
        MCCoroutineKt.launch$default(Atom.Companion.getInstance(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * Unable to fully structure code
             */
            @Override
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        v0 = DelayKt.delay(100L, this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        RecipeUnlockHandler.access$extractRecipeIngredients(RecipeUnlockHandler.INSTANCE);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Override
            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Override
            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }
}

